/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.core.geojson;

import cn.gtmap.gtcc.domain.gis.esm.FeatureCollection;
import cn.gtmap.gtcc.gis.core.geojson.BaseConverter;
import cn.gtmap.gtcc.utils.FileUtil;
import cn.gtmap.gtcc.utils.ZipUtil;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureSource;
import org.opengis.feature.simple.SimpleFeature;

public class Shp2Geojson
extends BaseConverter {
    private boolean simplify = false;
    private double distanceTolerance = 0.0;

    public Shp2Geojson() {
    }

    public Shp2Geojson(boolean simplify, double distanceTolerance) {
        this.simplify = simplify;
        this.distanceTolerance = distanceTolerance;
    }

    public boolean isSimplify() {
        return this.simplify;
    }

    public Shp2Geojson setSimplify(boolean simplify) {
        this.simplify = simplify;
        return this;
    }

    public double getDistanceTolerance() {
        return this.distanceTolerance;
    }

    public Shp2Geojson setDistanceTolerance(double distanceTolerance) {
        this.distanceTolerance = distanceTolerance;
        return this;
    }

    public List<FeatureCollection> getFromZipUrl(String url, String downloadPath) {
        Date currentTime = new Date();
        String dateString = this.formatter.format(currentTime);
        String name = UUID.randomUUID().toString();
        String zipFileName = name + dateString + ".zip";
        File zipFile = FileUtil.downloadFile((String)url, (String)downloadPath, (String)zipFileName);
        List<FeatureCollection> list = this.getFromZipFile(zipFile, downloadPath);
        if (zipFile.exists()) {
            FileUtil.deleteDir((File)zipFile);
        }
        return list;
    }

    public List<FeatureCollection> getFromZipFile(File zipFile, String downloadPath) {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateString = formatter.format(currentTime);
        String unzipFolderName = UUID.randomUUID().toString() + dateString;
        List<File> files = null;
        String unzipFolderPath = downloadPath + File.separator + unzipFolderName;
        try {
            files = this.unzip(zipFile, unzipFolderPath);
        }
        catch (Exception e) {
            return null;
        }
        ArrayList<FeatureCollection> list = new ArrayList<FeatureCollection>();
        for (File file : files) {
            if (!file.isFile() || !".shp".equals(this.getFileSuffix(file.getName()))) continue;
            list.add(this.getFromShpFile(file));
        }
        File unzipFolder = new File(unzipFolderPath);
        if (unzipFolder.exists()) {
            FileUtil.deleteDir((File)unzipFolder);
        }
        return list;
    }

    public List<String> getGeoJsonFromZipFile(File zipFile, String downloadPath) {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateString = formatter.format(currentTime);
        String unzipFolderName = UUID.randomUUID().toString() + dateString;
        List<File> files = null;
        String unzipFolderPath = downloadPath + File.separator + unzipFolderName;
        try {
            files = this.unzip(zipFile, unzipFolderPath);
        }
        catch (Exception e) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (File file : files) {
            if (!file.isFile() || !".shp".equals(this.getFileSuffix(file.getName()))) continue;
            list.add(this.getGeoJsonFromShpFile(file));
        }
        File unzipFolder = new File(unzipFolderPath);
        if (unzipFolder.exists()) {
            FileUtil.deleteDir((File)unzipFolder);
        }
        return list;
    }

    public List<FeatureCollection> getFromPath(String path) {
        File file = new File(path);
        ArrayList<FeatureCollection> list = new ArrayList<FeatureCollection>();
        if (file.isFile()) {
            if (".shp".equals(this.getFileSuffix(file.getName()))) {
                list.add(this.getFromShpFile(file));
            }
        } else {
            File[] files;
            for (File f : files = file.listFiles()) {
                if (!f.isFile() || !".shp".equals(this.getFileSuffix(f.getName()))) continue;
                list.add(this.getFromShpFile(f));
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleFeatureCollection getSimpleFeatureCollectionFromShpFile(File shpFile) {
        if (!".shp".equals(this.getFileSuffix(shpFile.getName()))) {
            return null;
        }
        ShapefileDataStore shpDataStore = null;
        try {
            shpDataStore = new ShapefileDataStore(shpFile.toURI().toURL());
            shpDataStore.setCharset(this.getShpCharset(shpFile));
            String typeName = shpDataStore.getTypeNames()[0];
            ContentFeatureSource featureSource = null;
            featureSource = shpDataStore.getFeatureSource(typeName);
            SimpleFeatureCollection fc = featureSource.getFeatures();
            if (this.simplify) {
                SimpleFeatureIterator fi = fc.features();
                while (fi.hasNext()) {
                    SimpleFeature sf = (SimpleFeature)fi.next();
                    Geometry geo = (Geometry)sf.getDefaultGeometry();
                    if (geo == null || geo.getNumPoints() <= 0 || !(geo instanceof Polygon) && !(geo instanceof MultiPolygon) && !(geo instanceof LineString) && !(geo instanceof MultiLineString)) continue;
                    DouglasPeuckerSimplifier simplifier = new DouglasPeuckerSimplifier(geo);
                    simplifier.setDistanceTolerance(this.distanceTolerance);
                    Geometry simplifyResultGeometry = simplifier.getResultGeometry();
                    if (simplifyResultGeometry == null || simplifyResultGeometry.getNumPoints() <= 0) continue;
                    sf.setDefaultGeometry((Object)simplifyResultGeometry);
                }
            }
            SimpleFeatureCollection simpleFeatureCollection = fc;
            return simpleFeatureCollection;
        }
        catch (Exception exception) {
        }
        finally {
            if (shpDataStore != null) {
                shpDataStore.dispose();
            }
        }
        return null;
    }

    public String getGeoJsonFromShpFile(File shpFile) {
        String json = "";
        try {
            SimpleFeatureCollection fc = this.getSimpleFeatureCollectionFromShpFile(shpFile);
            SimpleFeature firstFeature = (SimpleFeature)fc.toArray()[0];
            this.fjson.setEncodeFeatureCollectionBounds(firstFeature.getBounds() != null);
            this.fjson.setEncodeFeatureCollectionCRS(firstFeature.getFeatureType().getCoordinateReferenceSystem() != null);
            json = this.fjson.toString((org.geotools.feature.FeatureCollection)fc);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return json;
    }

    public FeatureCollection getFromShpFile(File shpFile) {
        return this.convertToFeatureCollection(this.getSimpleFeatureCollectionFromShpFile(shpFile));
    }

    private List<File> unzip(File zipFile, String unzipFolderPath) {
        File unzipFolder = new File(unzipFolderPath);
        if (!unzipFolder.exists()) {
            unzipFolder.mkdirs();
        }
        return ZipUtil.upzipFile((File)zipFile, (String)unzipFolderPath);
    }
}

