/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.core.geojson;

import cn.gtmap.gtcc.domain.gis.esm.FeatureCollection;
import cn.gtmap.gtcc.gis.core.geojson.BaseConverter;
import com.vividsolutions.jts.geom.Geometry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class Geojson2Shp
extends BaseConverter {
    private CoordinateReferenceSystem crs;

    public Geojson2Shp() {
    }

    public Geojson2Shp(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    public void setCrs(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public boolean exportShape(FeatureCollection featureCollection, String path, String name, String charSet, Map<String, Object> fieldMapping) {
        return this.exportShape(featureCollection.toJson(), path, name, charSet, fieldMapping);
    }

    public boolean exportShape(FeatureCollection featureCollection, String path, String name, String charSet) {
        return this.exportShape(featureCollection.toJson(), path, name, charSet, null);
    }

    public boolean exportShape(String geoJSON, String path, String name, String charSet, Map<String, Object> fieldMapping) {
        try {
            this.exportShape(this.convertToSimpleFeatureCollection(geoJSON), path, name, charSet, fieldMapping);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean exportShape(String geoJSON, String path, String name, String charSet) {
        return this.exportShape(geoJSON, path, name, charSet, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exportShape(SimpleFeatureCollection collection, String path, String fileName, String charSet, Map<String, Object> fieldMapping) throws IOException, IllegalAttributeException {
        File shp;
        String charset = charSet.toUpperCase();
        SimpleFeatureType type = (SimpleFeatureType)collection.getSchema();
        Object crs = type.getCoordinateReferenceSystem();
        boolean needRebuild = fieldMapping != null && !fieldMapping.isEmpty();
        boolean bl = needRebuild = needRebuild || type.getType("the_geom") == null;
        if (crs == null) {
            needRebuild = true;
            crs = this.crs != null ? this.crs : DefaultGeographicCRS.WGS84;
        }
        SimpleFeatureType newType = type;
        HashMap typeMap = new HashMap(5);
        if (needRebuild) {
            SimpleFeatureTypeBuilder typeBuilder = this.createFeatureTypeBuilder(type, (CoordinateReferenceSystem)crs, fieldMapping);
            newType = typeBuilder.buildFeatureType();
        }
        typeMap.put(type.getGeometryDescriptor().getType().getBinding(), newType);
        DefaultTransaction transaction = new DefaultTransaction("create");
        File folderFile = new File(path);
        if (!folderFile.exists()) {
            folderFile.mkdir();
        }
        if (!(shp = new File(path + File.separator + fileName + ".shp")).exists()) {
            shp.createNewFile();
        }
        ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put("url", shp.toURI().toURL());
        params.put("create spatial index", Boolean.TRUE);
        params.put("charset", charset);
        ShapefileDataStore dataStore = (ShapefileDataStore)dataStoreFactory.createNewDataStore(params);
        dataStore.createSchema(newType);
        dataStore.forceSchemaCRS(newType.getCoordinateReferenceSystem());
        dataStore.setCharset(Charset.forName(charset));
        String typeName = dataStore.getTypeNames()[0];
        ContentFeatureSource featureSource = dataStore.getFeatureSource(typeName);
        SimpleFeatureStore featureStore = (SimpleFeatureStore)featureSource;
        featureStore.setTransaction((Transaction)transaction);
        if (needRebuild) {
            DefaultFeatureCollection newFeatureCollection = new DefaultFeatureCollection(collection.getID(), newType);
            SimpleFeatureIterator fi = collection.features();
            SimpleFeatureBuilder featureBuilder = null;
            while (fi.hasNext()) {
                SimpleFeature sf = (SimpleFeature)fi.next();
                Geometry geo = (Geometry)sf.getDefaultGeometry();
                SimpleFeatureType featureType = (SimpleFeatureType)typeMap.get(geo.getClass());
                if (featureType == null) {
                    featureType = this.createFeatureTypeBuilder(sf.getFeatureType(), (CoordinateReferenceSystem)crs, fieldMapping).buildFeatureType();
                    typeMap.put(geo.getClass(), featureType);
                }
                featureBuilder = new SimpleFeatureBuilder(featureType);
                for (AttributeType attributeType : newType.getTypes()) {
                    if (attributeType.getName().getLocalPart().equals("the_geom")) {
                        featureBuilder.add((Object)geo);
                        continue;
                    }
                    featureBuilder.add(sf.getProperty(attributeType.getName()).getValue());
                }
                newFeatureCollection.add(featureBuilder.buildFeature(sf.getID()));
            }
            fi.close();
            collection = newFeatureCollection;
        }
        try {
            featureStore.addFeatures((org.geotools.feature.FeatureCollection)collection);
            transaction.commit();
            this.createCpgFile(path, fileName, charset);
            boolean newFeatureCollection = true;
            return newFeatureCollection;
        }
        catch (Exception e) {
            e.printStackTrace();
            transaction.rollback();
        }
        finally {
            transaction.close();
        }
        return false;
    }

    private SimpleFeatureTypeBuilder createFeatureTypeBuilder(SimpleFeatureType featureType, CoordinateReferenceSystem crs, Map<String, Object> fieldMapping) {
        SimpleFeatureTypeBuilder featureTypeBuilder = new SimpleFeatureTypeBuilder();
        featureTypeBuilder.init(featureType);
        featureTypeBuilder.setName(featureType.getName());
        if (featureTypeBuilder.get("the_geom") == null) {
            featureTypeBuilder.add("the_geom", featureType.getGeometryDescriptor().getType().getBinding(), crs);
            featureTypeBuilder.setDefaultGeometry("the_geom");
            featureTypeBuilder.remove(featureType.getGeometryDescriptor().getName().getLocalPart());
        }
        featureTypeBuilder.setCRS(crs);
        List attributeTypeList = featureType.getTypes();
        AttributeTypeBuilder attributeTypeBuilder = new AttributeTypeBuilder(featureTypeBuilder.getFeatureTypeFactory());
        for (AttributeType attributeType : attributeTypeList) {
            String fieldName = attributeType.getName().getLocalPart();
            if (!"java.lang.Object".equals(attributeType.getBinding().getName())) continue;
            attributeTypeBuilder.setBinding(String.class);
            attributeTypeBuilder.setName(fieldName);
            featureTypeBuilder.set(fieldName, attributeTypeBuilder.buildDescriptor(fieldName));
        }
        if (fieldMapping != null) {
            this.reBuildType(featureTypeBuilder, attributeTypeBuilder, fieldMapping);
        }
        return featureTypeBuilder;
    }

    private void reBuildType(SimpleFeatureTypeBuilder featureTypeBuilder, AttributeTypeBuilder attributeTypeBuilder, Map<String, Object> fieldMapping) {
        for (Map.Entry<String, Object> entry : fieldMapping.entrySet()) {
            String key = entry.getKey();
            AttributeDescriptor descriptor = featureTypeBuilder.get(key);
            if (descriptor == null || descriptor.getType().getBinding().isAssignableFrom(Geometry.class)) continue;
            try {
                attributeTypeBuilder.setBinding(this.getFieldClass(fieldMapping, key));
            }
            catch (ClassNotFoundException e) {
                this.logger.error("\u5b57\u6bb5\u7c7b\u578b\u4e0d\u5b58\u5728", (Throwable)e);
                attributeTypeBuilder.setBinding(String.class);
            }
            attributeTypeBuilder.setName(key);
            featureTypeBuilder.set(key, attributeTypeBuilder.buildDescriptor(key));
        }
    }

    private Class<?> getFieldClass(Map<String, Object> fieldMapping, String key) throws ClassNotFoundException {
        return Class.forName(String.valueOf(fieldMapping.get(key)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCpgFile(String path, String fileName, String charSet) {
        OutputStreamWriter fw = null;
        BufferedWriter bw = null;
        try {
            File file = new File(path + File.separator + fileName + ".cpg");
            if (!file.exists()) {
                file.createNewFile();
            }
            fw = new FileWriter(file, false);
            bw = new BufferedWriter(fw);
            bw.write(charSet);
            bw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

