/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.core.geojson;

import cn.gtmap.gtcc.domain.gis.esm.CRS;
import cn.gtmap.gtcc.domain.gis.esm.Feature;
import cn.gtmap.gtcc.domain.gis.esm.FeatureCollection;
import cn.gtmap.gtcc.gis.core.jtsgeo.JTSGeometryFactory;
import cn.gtmap.gtcc.gis.core.jtsgeo.JTSGeometryHelper;
import cn.gtmap.gtcc.gis.core.util.GeometryUtils;
import cn.gtmap.gtcc.gis.core.util.SRTransformations;
import cn.gtmap.gtcc.utils.UUIDGenerator;
import cn.gtmap.gtcc.utils.Utils;
import com.alibaba.fastjson.JSONArray;
import com.esri.sde.sdk.client.SeColumnDefinition;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeRow;
import com.esri.sde.sdk.client.SeShape;
import com.esri.sde.sdk.pe.PeCoordinateSystem;
import com.esri.sde.sdk.pe.PeProjectedCS;
import com.esri.sde.sdk.pe.PeProjectionException;
import com.google.common.collect.Maps;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geojson.feature.FeatureJSON;
import org.geotools.geojson.geom.GeometryJSON;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseConverter {
    final String FEATURE_FIELD = "Feature";
    final String DATE_FORMAT = "yyyyMMddHHmmss";
    final String CRS_TYPE_NAME = "name";
    final String CRS_TYPE_VALUE = "value";
    final int SHP_TEXT_MAX_BYTES = 254;
    boolean changePrecison = false;
    int precison = 16;
    GeometryJSON gjson = new GeometryJSON(16);
    FeatureJSON fjson = new FeatureJSON(this.gjson);
    SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    GeometryFactory geometryFactory = new GeometryFactory();
    JTSGeometryFactory jtsGeometryFactory = new JTSGeometryFactory(this.geometryFactory);
    JTSGeometryHelper jtsGeometryHelper = new JTSGeometryHelper();

    public GeometryJSON getGjson() {
        return this.gjson;
    }

    public FeatureJSON getFjson() {
        return this.fjson;
    }

    public BaseConverter() {
    }

    public BaseConverter(int precision) {
        this.changePrecison = true;
        this.precison = precision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Charset getShpCharset(File shpFile) {
        String cpgFileUrl = shpFile.getPath();
        File cpgFile = new File(cpgFileUrl = cpgFileUrl.substring(0, cpgFileUrl.length() - 4) + ".cpg");
        if (!cpgFile.exists()) {
            return Charset.forName("gbk");
        }
        StringBuilder result = new StringBuilder();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(cpgFileUrl));
            String s = null;
            while ((s = br.readLine()) != null) {
                result.append(s);
            }
            br.close();
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u53d6cpg\u95ee\u4ef6\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                this.logger.error(ex.getLocalizedMessage());
            }
        }
        return Charset.forName(result.toString());
    }

    String getFileSuffix(String fileName) {
        return fileName.substring(fileName.lastIndexOf("."));
    }

    public FeatureCollection convertToFeatureCollection(String geojson) {
        return FeatureCollection.fromJson((String)geojson);
    }

    public Geometry convertToJtsGeometry(String geojson) throws IOException {
        return this.gjson.read((Object)geojson);
    }

    public Geometry convertToJtsGeometry(Feature.Geometry geometry) throws IOException {
        return this.jtsGeometryFactory.createGeometry(geometry, false);
    }

    public SimpleFeatureCollection convertToSimpleFeatureCollection(String geojson) throws IOException {
        return (SimpleFeatureCollection)this.fjson.readFeatureCollection((Object)geojson);
    }

    public SimpleFeatureCollection convertToSimpleFeatureCollection(FeatureCollection fc) throws IOException {
        CRS crs = fc.getCrs();
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        if (crs != null) {
            if ("name".equals(crs.getType())) {
                coordinateReferenceSystem = this.jtsGeometryHelper.getCRSByCommnonString(MapUtils.getString((Map)crs.getProperties(), (Object)"name"));
            } else if ("value".equals(crs.getType())) {
                coordinateReferenceSystem = this.jtsGeometryHelper.getCRSByWKTString(MapUtils.getString((Map)crs.getProperties(), (Object)"value"));
            }
        }
        DefaultFeatureCollection featureCollection = new DefaultFeatureCollection();
        for (Feature feature : fc.getFeatures()) {
            featureCollection.add(this.convertToSimpleFeature(feature, coordinateReferenceSystem));
        }
        return featureCollection;
    }

    public SimpleFeature convertToSimpleFeature(SeRow seRow) {
        Map<String, Object> rowMap = this.convertToMap(seRow, true);
        if (rowMap == null || rowMap.get("geometry") == null) {
            return null;
        }
        Map properties = MapUtils.getMap(rowMap, (Object)"properties", (Map)Maps.newHashMap());
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("Feature");
        typeBuilder.add("geometry", MapUtils.getObject(rowMap, (Object)"geometry").getClass());
        Iterator iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            typeBuilder.add(key, properties.get(key = (String)iterator.next()) != null ? properties.get(key).getClass() : String.class);
        }
        SimpleFeatureType featureType = typeBuilder.buildFeatureType();
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
        featureBuilder.add(rowMap.get("geometry"));
        for (String key : properties.keySet()) {
            featureBuilder.add(properties.get(key));
        }
        return featureBuilder.buildFeature("Feature".concat(UUIDGenerator.generate()));
    }

    public SimpleFeature convertToSimpleFeature(Feature feature, CoordinateReferenceSystem crs) throws IOException {
        Map properties = feature.getProperties();
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("Feature");
        if (crs != null) {
            typeBuilder.setCRS(crs);
        }
        Geometry geometry = this.convertToJtsGeometry(feature.getGeometry());
        typeBuilder.add("geometry", geometry.getClass());
        Iterator iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            typeBuilder.add(key, properties.get(key = (String)iterator.next()) != null ? properties.get(key).getClass() : String.class);
        }
        SimpleFeatureType featureType = typeBuilder.buildFeatureType();
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
        featureBuilder.add((Object)geometry);
        for (String key : properties.keySet()) {
            featureBuilder.add(properties.get(key));
        }
        return featureBuilder.buildFeature("Feature".concat(UUIDGenerator.generate()));
    }

    public Map<String, Object> convertToMap(SeRow row, boolean isJts) {
        if (row == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        HashMap<String, Object> properties = new HashMap<String, Object>(16);
        try {
            int colCount = row.getNumColumns();
            SeColumnDefinition colDef = null;
            for (int i = 0; i < colCount; ++i) {
                colDef = row.getColumnDef(i);
                try {
                    int type = colDef.getType();
                    switch (type) {
                        case 5: {
                            properties.put(colDef.getName(), this.formatStringValue(row.getString(i)));
                            break;
                        }
                        case 14: {
                            properties.put(colDef.getName(), this.formatStringValue(row.getNString(i)));
                            break;
                        }
                        case 2: {
                            properties.put(colDef.getName(), row.getInteger(i));
                            break;
                        }
                        case 8: {
                            try {
                                if (isJts) {
                                    map.put("geometry", GeometryUtils.convertSeShape(row.getShape(i)));
                                    break;
                                }
                                map.put("geometry", this.convertToGeometry(row.getShape(i)));
                            }
                            catch (SeException e) {
                                this.logger.error("SDE Shape\u7c7b\u578b\u5b57\u6bb5\u8f6c\u6362\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef", (Throwable)e);
                            }
                            break;
                        }
                        case 7: {
                            properties.put(colDef.getName(), row.getTime(i) != null ? row.getTime(i).getTime() : "");
                            break;
                        }
                        case 1: {
                            properties.put(colDef.getName(), row.getShort(i));
                            break;
                        }
                        case 11: {
                            properties.put(colDef.getName(), row.getLong(i));
                            break;
                        }
                        case 3: {
                            properties.put(colDef.getName(), row.getFloat(i));
                            break;
                        }
                        case 4: {
                            properties.put(colDef.getName(), row.getDouble(i));
                            break;
                        }
                        case 12: {
                            properties.put(colDef.getName(), row.getUuid(i));
                            break;
                        }
                        case 13: {
                            try {
                                properties.put(colDef.getName(), IOUtils.toString((InputStream)row.getClob(i), (String)"utf-8"));
                            }
                            catch (IOException e) {
                                this.logger.error("SDE CLOB\u7c7b\u578b\u5b57\u6bb5\u8f6c\u6362\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef", (Throwable)e);
                            }
                            break;
                        }
                        case 15: {
                            try {
                                properties.put(colDef.getName(), IOUtils.toString((InputStream)row.getNClob(i), (String)"utf-8"));
                            }
                            catch (IOException e) {
                                this.logger.error("SDE NCLOB\u7c7b\u578b\u5b57\u6bb5\u8f6c\u6362\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef", (Throwable)e);
                            }
                            break;
                        }
                        case 10: {
                            properties.put(colDef.getName(), row.getXml(i) != null ? row.getXml(i).getText() : "");
                            break;
                        }
                    }
                    continue;
                }
                catch (SeException e) {
                    this.logger.error("\u8bfb\u53d6SDE\u5b57\u6bb5\u5185\u5bb9\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
                }
            }
        }
        catch (SeException e) {
            this.logger.error("\u8bfb\u53d6SDE\u884c\u5185\u5bb9\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u53d6SDE\u884c\u5185\u5bb9\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        map.put("properties", properties);
        return map;
    }

    public Map<String, Object> convertToMap(SimpleFeature feature, boolean toJts) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        HashMap<String, Object> properties = new HashMap<String, Object>(16);
        for (AttributeType attributeType : feature.getFeatureType().getTypes()) {
            if (Geometry.class.isAssignableFrom(attributeType.getBinding())) {
                if (toJts) {
                    map.put("geometry", feature.getDefaultGeometry());
                    continue;
                }
                map.put("geometry", this.convertToGeometry((Geometry)feature.getDefaultGeometry()));
                continue;
            }
            properties.put(attributeType.getName().getLocalPart(), feature.getProperty(attributeType.getName()).getValue());
        }
        map.put("properties", properties);
        return map;
    }

    public Map<String, Object> convertToMap(Feature feature, boolean toJts) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("properties", feature.getProperties());
        if (toJts) {
            map.put("geometry", this.convertToJtsGeometry(feature.getGeometry()));
        } else {
            map.put("geometry", feature.getGeometry());
        }
        return map;
    }

    public Feature convertToFeature(SeRow seRow) {
        Feature feature = new Feature();
        feature.setType("Feature");
        Map<String, Object> rowMap = this.convertToMap(seRow, false);
        if (rowMap == null || rowMap.get("geometry") == null) {
            return null;
        }
        feature.setProperties(MapUtils.getMap(rowMap, (Object)"properties", (Map)Maps.newHashMap()));
        feature.setGeometry((Feature.Geometry)MapUtils.getObject(rowMap, (Object)"geometry"));
        return feature;
    }

    public Feature.Geometry convertToGeometry(SeShape seShape) {
        Feature.Geometry geo = new Feature.Geometry();
        try {
            double[][][] coordinates = seShape.getAllCoords(Integer.MAX_VALUE);
            switch (seShape.getType()) {
                case 1: {
                    geo.setType("Point");
                    geo.setCoordinates(this.createPoint(coordinates));
                    break;
                }
                case 257: {
                    geo.setType("MultiPoint");
                    geo.setCoordinates(this.createMultiPoint(coordinates));
                    break;
                }
                case 4: {
                    geo.setType("LineString");
                    geo.setCoordinates(this.createLine(coordinates));
                    break;
                }
                case 2: {
                    geo.setType("LineString");
                    geo.setCoordinates(this.createLine(coordinates));
                    break;
                }
                case 260: {
                    geo.setType("MultiLineString");
                    geo.setCoordinates(this.createMultiLine(coordinates));
                    break;
                }
                case 258: {
                    geo.setType("MultiLineString");
                    geo.setCoordinates(this.createMultiLine(coordinates));
                    break;
                }
                case 8: {
                    geo.setType("Polygon");
                    geo.setCoordinates(this.createPolygon(coordinates));
                    break;
                }
                case 264: {
                    geo.setType("MultiPolygon");
                    geo.setCoordinates(this.createMultiPolygon(coordinates));
                    break;
                }
            }
        }
        catch (SeException e) {
            this.logger.error("SDE Shape\u8f6c\u6362\u6210\u81ea\u5b9a\u4e49Geometry\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        return geo;
    }

    private double formatDoubleValue(double value) {
        return this.changePrecison ? this.formatDoubleValue(value, this.precison) : value;
    }

    private double formatDoubleValue(double value, int precison) {
        return Utils.round((double)value, (int)precison);
    }

    private String formatStringValue(String value) {
        if (StringUtils.isNotEmpty((String)value) && value.getBytes().length > 254) {
            try {
                return Utils.substr((String)value, (String)"utf-8", (int)254);
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error("\u5b57\u7b26\u4e32\u622a\u53d6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            }
        }
        return value;
    }

    private List createPoint(double[][][] coordinates) {
        JSONArray point = new JSONArray();
        for (int i = 0; i < coordinates.length; ++i) {
            double[][] temp = coordinates[i];
            for (int j = 0; j < temp.length; ++j) {
                for (int m = 0; m < temp[j].length; ++m) {
                    point = new JSONArray();
                    point.add((Object)this.formatDoubleValue(temp[j][m]));
                    point.add((Object)this.formatDoubleValue(temp[j][++m]));
                }
            }
        }
        return point;
    }

    private List createMultiPoint(double[][][] coordinates) {
        JSONArray multiPoint = new JSONArray();
        for (int i = 0; i < coordinates.length; ++i) {
            double[][] temp = coordinates[i];
            for (int j = 0; j < temp.length; ++j) {
                for (int m = 0; m < temp[j].length; ++m) {
                    JSONArray point = new JSONArray();
                    point.add((Object)this.formatDoubleValue(temp[j][m]));
                    point.add((Object)this.formatDoubleValue(temp[j][++m]));
                    multiPoint.add((Object)point);
                }
            }
        }
        return multiPoint;
    }

    private List createLine(double[][][] coordinates) {
        JSONArray lineString = new JSONArray();
        for (int i = 0; i < coordinates.length; ++i) {
            double[][] temp = coordinates[i];
            for (int j = 0; j < temp.length; ++j) {
                lineString = new JSONArray();
                for (int m = 0; m < temp[j].length; ++m) {
                    JSONArray point = new JSONArray();
                    point.add((Object)this.formatDoubleValue(temp[j][m]));
                    point.add((Object)this.formatDoubleValue(temp[j][++m]));
                    lineString.add((Object)point);
                }
            }
        }
        return lineString;
    }

    private List createMultiLine(double[][][] coordinates) {
        JSONArray multiLine = new JSONArray();
        for (int i = 0; i < coordinates.length; ++i) {
            double[][] temp = coordinates[i];
            for (int j = 0; j < temp.length; ++j) {
                JSONArray lineString = new JSONArray();
                for (int m = 0; m < temp[j].length; ++m) {
                    JSONArray point = new JSONArray();
                    point.add((Object)this.formatDoubleValue(temp[j][m]));
                    point.add((Object)this.formatDoubleValue(temp[j][++m]));
                    lineString.add((Object)point);
                }
                multiLine.add((Object)lineString);
            }
        }
        return multiLine;
    }

    private List createPolygon(double[][][] coordinates) {
        JSONArray polygon = new JSONArray();
        for (int i = 0; i < coordinates.length; ++i) {
            double[][] temp = coordinates[i];
            polygon = new JSONArray();
            for (int j = 0; j < temp.length; ++j) {
                JSONArray lineString = new JSONArray();
                for (int m = 0; m < temp[j].length; ++m) {
                    JSONArray point = new JSONArray();
                    point.add((Object)this.formatDoubleValue(temp[j][m]));
                    point.add((Object)this.formatDoubleValue(temp[j][++m]));
                    lineString.add((Object)point);
                }
                polygon.add((Object)lineString);
            }
        }
        return polygon;
    }

    private List createMultiPolygon(double[][][] coordinates) {
        JSONArray polygons = new JSONArray();
        for (int i = 0; i < coordinates.length; ++i) {
            double[][] temp = coordinates[i];
            JSONArray polygon = new JSONArray();
            for (int j = 0; j < temp.length; ++j) {
                JSONArray lineString = new JSONArray();
                for (int m = 0; m < temp[j].length; ++m) {
                    JSONArray point = new JSONArray();
                    point.add((Object)this.formatDoubleValue(temp[j][m]));
                    point.add((Object)this.formatDoubleValue(temp[j][++m]));
                    lineString.add((Object)point);
                }
                polygon.add((Object)lineString);
            }
            polygons.add((Object)polygon);
        }
        return polygons;
    }

    public FeatureCollection convertToFeatureCollection(SimpleFeatureCollection sfc) {
        SimpleFeatureIterator fi = sfc.features();
        FeatureCollection fc = new FeatureCollection();
        ArrayList<Feature> features = new ArrayList<Feature>();
        while (fi.hasNext()) {
            SimpleFeature sf = (SimpleFeature)fi.next();
            features.add(this.convertToFeature(sf));
        }
        fi.close();
        fc.setFeatures(features);
        fc.setBbox(this.getBBox(sfc.getBounds()));
        CoordinateReferenceSystem crs = ((SimpleFeatureType)sfc.getSchema()).getCoordinateReferenceSystem();
        if (crs != null) {
            HashMap<String, String> map = new HashMap<String, String>(1);
            map.put("value", crs.toWKT());
            fc.setCrs(new CRS(CRS.Type.value, map));
        }
        return fc;
    }

    private List<Double> getBBox(ReferencedEnvelope bounds) {
        int i;
        ArrayList<Double> list = new ArrayList<Double>();
        for (i = 0; i < bounds.getDimension(); ++i) {
            list.add(bounds.getMinimum(i));
        }
        for (i = 0; i < bounds.getDimension(); ++i) {
            list.add(bounds.getMaximum(i));
        }
        return list;
    }

    public Feature convertToFeature(SimpleFeature sf) {
        if (sf == null) {
            return null;
        }
        Feature feature = new Feature();
        feature.setGeometry(this.convertToGeometry((Geometry)sf.getDefaultGeometry()));
        feature.setProperties(this.getPropertiesMap(sf));
        feature.setId(sf.getID());
        return feature;
    }

    public Feature.Geometry convertToGeometry(Geometry geometry) {
        return this.jtsGeometryFactory.fromGeometry(geometry);
    }

    public Map<String, Object> getPropertiesMap(SimpleFeature sf) {
        if (sf == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> properties = new HashMap<String, Object>(16);
        for (AttributeType attributeType : sf.getFeatureType().getTypes()) {
            if (Geometry.class.isAssignableFrom(attributeType.getBinding())) continue;
            properties.put(attributeType.getName().getLocalPart(), sf.getProperty(attributeType.getName()).getValue());
        }
        return properties;
    }

    public SimpleFeatureCollection transformToGeographic(SimpleFeatureCollection featureCollection, boolean transformByJts) {
        CoordinateReferenceSystem crs = ((SimpleFeatureType)featureCollection.getSchema()).getCoordinateReferenceSystem();
        if (crs != null && crs instanceof ProjectedCRS) {
            if (transformByJts) {
                DefaultFeatureCollection collection = new DefaultFeatureCollection(null, null);
                SimpleFeatureIterator featureIterator = featureCollection.features();
                while (featureIterator.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)featureIterator.next();
                    SimpleFeature resultFeature = this.transformToGeographic(feature, true);
                    if (resultFeature == null) continue;
                    collection.add(resultFeature);
                }
                featureIterator.close();
                return collection;
            }
            PeCoordinateSystem fromPCS = null;
            PeProjectedCS pf = null;
            try {
                fromPCS = SRTransformations.getCoordinateSystem(crs.toWKT());
                pf = fromPCS instanceof PeProjectedCS ? (PeProjectedCS)fromPCS : null;
            }
            catch (PeProjectionException e) {
                return featureCollection;
            }
            if (pf != null) {
                return (SimpleFeatureCollection)this.jtsGeometryHelper.project(featureCollection, crs, this.jtsGeometryHelper.getCRSByWKTString(pf.getGeogCoordSys().toString()));
            }
        }
        return featureCollection;
    }

    public SimpleFeature transformToGeographic(SimpleFeature feature, boolean transformByJts) {
        SimpleFeatureType featureType = feature.getFeatureType();
        CoordinateReferenceSystem crs = featureType.getCoordinateReferenceSystem();
        if (crs != null && crs instanceof ProjectedCRS) {
            if (transformByJts) {
                GeographicCRS baseCrs = ((ProjectedCRS)crs).getBaseCRS();
                MathTransform transform = null;
                try {
                    transform = org.geotools.referencing.CRS.findMathTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)baseCrs);
                }
                catch (FactoryException e) {
                    this.logger.error("\u67e5\u627e\u6295\u5f71\u5750\u6807\u7cfb\u5230\u5730\u7406\u5750\u6807\u7cfb\u7684\u8f6c\u6362\u65b9\u6cd5\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
                    return null;
                }
                SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
                typeBuilder.init(featureType);
                typeBuilder.setName(featureType.getName());
                typeBuilder.remove(featureType.getGeometryDescriptor().getLocalName());
                typeBuilder.setCRS((CoordinateReferenceSystem)baseCrs);
                typeBuilder.add(featureType.getGeometryDescriptor().getLocalName(), feature.getDefaultGeometry().getClass());
                SimpleFeatureType newFeatureType = typeBuilder.buildFeatureType();
                SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(newFeatureType);
                for (PropertyDescriptor pd : newFeatureType.getDescriptors()) {
                    Object pValue = feature.getProperty(pd.getName().getLocalPart()).getValue();
                    if (pd.getName().getLocalPart().equals(newFeatureType.getGeometryDescriptor().getLocalName())) {
                        try {
                            featureBuilder.add((Object)JTS.transform((Geometry)((Geometry)pValue), (MathTransform)transform));
                            continue;
                        }
                        catch (TransformException e) {
                            this.logger.error("\u5750\u6807\u7cfb\u8f6c\u6362\u9519\u8bef", (Throwable)e);
                            return null;
                        }
                    }
                    featureBuilder.add(pValue);
                }
                return featureBuilder.buildFeature(feature.getID());
            }
            PeCoordinateSystem fromPCS = null;
            PeProjectedCS pf = null;
            try {
                fromPCS = SRTransformations.getCoordinateSystem(crs.toWKT());
                pf = fromPCS instanceof PeProjectedCS ? (PeProjectedCS)fromPCS : null;
            }
            catch (PeProjectionException e) {
                return feature;
            }
            if (pf != null) {
                return (SimpleFeature)this.jtsGeometryHelper.project(feature, crs, this.jtsGeometryHelper.getCRSByWKTString(pf.getGeogCoordSys().toString()));
            }
        }
        return feature;
    }

    public String listToGeometryCollection(List<String> lstGeometry) {
        try {
            Geometry[] geometryList = new Geometry[lstGeometry.size()];
            for (int i = 0; i < lstGeometry.size(); ++i) {
                geometryList[i] = this.convertToJtsGeometry(lstGeometry.get(i));
            }
            GeometryCollection geometryCollection = new GeometryCollection(geometryList, new GeometryFactory());
            return this.jtsGeometryHelper.toGeoJSON((Geometry)geometryCollection);
        }
        catch (Exception ex) {
            throw new RuntimeException("ListGeometry2GeometryCollection\u8f6c\u6362\u5931\u8d25\uff1a" + ex.getLocalizedMessage());
        }
    }

    public List<Map<String, Object>> convertToListMap(FeatureCollection fc) {
        try {
            if (fc == null) {
                return null;
            }
            List features = fc.getFeatures();
            if (features != null && features.size() > 0) {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                for (Feature feature : features) {
                    list.add(this.convertToMap(feature, false));
                }
                return list;
            }
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException("featureCollection to List<?>\u8f6c\u6362\u5931\u8d25\uff1a" + ex.getLocalizedMessage());
        }
    }
}

