/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.core.geo;

import cn.gtmap.gtcc.domain.gis.esm.Feature;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class BoundingBox
implements Serializable {
    public static final BoundingBox EPSG_4326_BBOX = new BoundingBox(-180.0, -90.0, 180.0, 90.0);
    public static final BoundingBox EPSG_3857_BBOX = new BoundingBox(-2.003750834E7, -2.003750834E7, 2.003750834E7, 2.003750834E7);
    public static final BoundingBox EPSG_4490_BBOX = new BoundingBox(-180.0, -90.0, 180.0, 90.0);
    private static double EQUALITYTHRESHOLD = 0.03;
    private double xMin;
    private double yMin;
    private double xMax;
    private double yMax;

    public BoundingBox() {
    }

    public BoundingBox(double xMin, double yMin, double xMax, double yMax) {
        this.xMin = xMin;
        this.yMin = yMin;
        this.xMax = xMax;
        this.yMax = yMax;
    }

    public BoundingBox(BoundingBox boundingBox) {
        this.xMin = boundingBox.getxMin();
        this.xMax = boundingBox.getxMax();
        this.yMin = boundingBox.getyMin();
        this.yMax = boundingBox.getyMax();
    }

    public double getxMin() {
        return this.xMin;
    }

    public BoundingBox setxMin(double xMin) {
        this.xMin = xMin;
        return this;
    }

    public double getyMin() {
        return this.yMin;
    }

    public BoundingBox setyMin(double yMin) {
        this.yMin = yMin;
        return this;
    }

    public double getxMax() {
        return this.xMax;
    }

    public BoundingBox setxMax(double xMax) {
        this.xMax = xMax;
        return this;
    }

    public double getyMax() {
        return this.yMax;
    }

    public BoundingBox setyMax(double yMax) {
        this.yMax = yMax;
        return this;
    }

    public double getWidth() {
        return this.xMax - this.xMin;
    }

    public double getHeight() {
        return this.yMax - this.yMin;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            BoundingBox other = (BoundingBox)obj;
            return this.equals(other, EQUALITYTHRESHOLD);
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(BoundingBox other, double threshold) {
        return Math.abs(this.getxMin() - other.getxMin()) < threshold && Math.abs(this.getyMin() - other.getyMin()) < threshold && Math.abs(this.getWidth() - other.getWidth()) < threshold && Math.abs(this.getHeight() - other.getHeight()) < threshold;
    }

    public boolean isNull() {
        return this.xMax < this.xMin || this.yMin > this.yMax;
    }

    public boolean isSane() {
        return this.xMin < this.xMax && this.yMin < this.yMax;
    }

    public boolean intersects(BoundingBox other) {
        if (this.isNull() || other.isNull()) {
            return false;
        }
        return !(other.getxMin() > this.getxMax() || other.getxMax() < this.getxMin() || other.getyMin() > this.getyMax() || other.getyMax() < this.getyMin());
    }

    public BoundingBox intersection(BoundingBox box) {
        BoundingBox retBbox = new BoundingBox(0.0, 0.0, -1.0, -1.0);
        if (this.intersects(box)) {
            if (this.getxMin() < box.getxMin()) {
                retBbox.setxMin(box.getxMin());
            } else {
                retBbox.setxMin(this.getxMin());
            }
            if (this.getyMin() < box.getyMin()) {
                retBbox.setyMax(box.getyMin());
            } else {
                retBbox.setyMin(this.getyMin());
            }
            if (this.getxMax() > box.getxMax()) {
                retBbox.setxMax(box.getxMax());
            } else {
                retBbox.setxMax(this.getxMax());
            }
            if (this.getyMax() > box.getyMax()) {
                retBbox.setyMax(box.getyMax());
            } else {
                retBbox.setyMax(this.getyMax());
            }
        }
        return retBbox;
    }

    public void scale(double xFactor, double yFactor) {
        double dx = this.xMax - this.xMin;
        double xf = (dx * xFactor - dx) * 0.5;
        double dy = this.yMax - this.yMin;
        double yf = (dy * yFactor - dy) * 0.5;
        this.xMin -= xf;
        this.yMin -= yf;
        this.xMax += xf;
        this.yMax += yf;
    }

    public void sacle(double factor) {
        this.scale(factor, factor);
    }

    public boolean contains(BoundingBox other) {
        return this.xMin - EQUALITYTHRESHOLD <= other.xMin && this.yMin - EQUALITYTHRESHOLD <= other.yMin && this.xMax + EQUALITYTHRESHOLD >= other.xMax && this.yMax + EQUALITYTHRESHOLD >= other.yMax;
    }

    public String toString() {
        return "BoundingBox{xMin=" + this.xMin + ", yMin=" + this.yMin + ", xMax=" + this.xMax + ", yMax=" + this.yMax + '}';
    }

    public Feature toGeoJSON() {
        List<Double> bb = Arrays.asList(this.xMin, this.yMin);
        List<Double> br = Arrays.asList(this.xMax, this.yMin);
        List<Double> tr = Arrays.asList(this.xMax, this.yMax);
        List<Double> tl = Arrays.asList(this.xMin, this.yMax);
        List<List> c2 = Arrays.asList(bb, br, tr, tl, bb);
        List<List> c1 = Arrays.asList(c2);
        Feature.Geometry geometry = new Feature.Geometry().setType("Polygon").setCoordinates(c1);
        return new Feature().setGeometry(geometry).setType("Feature");
    }
}

