/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.core.analyze;

import cn.gtmap.gtcc.domain.gis.sde.LayerRegionC;
import cn.gtmap.gtcc.gis.core.jtsgeo.JTSGeometryHelper;
import org.apache.commons.lang.StringUtils;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class LayerRegion {
    private String layerName = "";
    private String regionField = "";
    private CoordinateReferenceSystem sourceLayerCRS = null;

    public LayerRegion(String layerName, String regionField) {
        this.layerName = layerName;
        this.regionField = regionField;
    }

    public LayerRegion(String layerName, CoordinateReferenceSystem sourceLayerCRS) {
        this.layerName = layerName;
        this.sourceLayerCRS = sourceLayerCRS;
    }

    public LayerRegion(LayerRegionC layerRegionC) {
        this.layerName = layerRegionC.getLayerName();
        this.regionField = layerRegionC.getRegionField();
        if (StringUtils.isNotEmpty((String)layerRegionC.getWktCrs())) {
            this.sourceLayerCRS = new JTSGeometryHelper().getCRSByWKTString(layerRegionC.getWktCrs());
        }
    }

    public String getLayerName() {
        return this.layerName;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public String getRegionField() {
        return this.regionField;
    }

    public void setRegionField(String regionField) {
        this.regionField = regionField;
    }

    public CoordinateReferenceSystem getSourceLayerCRS() {
        return this.sourceLayerCRS;
    }

    public void setSourceLayerCRS(CoordinateReferenceSystem sourceLayerCRS) {
        this.sourceLayerCRS = sourceLayerCRS;
    }
}

