/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.core.agsgeo;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorExportToGeoJson;
import com.esri.core.geometry.OperatorFactoryLocal;
import com.esri.core.geometry.OperatorImportFromESRIShape;
import com.esri.core.geometry.OperatorSimplify;
import com.esri.core.geometry.SpatialReference;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgsGeometryHelper {
    private OperatorFactoryLocal operatorFactory = OperatorFactoryLocal.getInstance();
    final Logger logger = LoggerFactory.getLogger(this.getClass());

    public String intersection(String inputGeometry, String intersector, String sr) {
        try {
            Geometry resultGeoemtry;
            Geometry tmpGeo1 = GeometryEngine.geometryFromWkt((String)inputGeometry, (int)0, (Geometry.Type)Geometry.Type.Unknown);
            Geometry tmpGeo2 = GeometryEngine.geometryFromWkt((String)intersector, (int)0, (Geometry.Type)Geometry.Type.Unknown);
            SpatialReference spatialReference = SpatialReference.create((String)sr);
            OperatorSimplify operatorSimplify = (OperatorSimplify)this.operatorFactory.getOperator(Operator.Type.Simplify);
            if (!operatorSimplify.isSimpleAsFeature(tmpGeo1, spatialReference, null)) {
                tmpGeo1 = GeometryEngine.simplify((Geometry)tmpGeo1, (SpatialReference)spatialReference);
            }
            if (!operatorSimplify.isSimpleAsFeature(tmpGeo2, spatialReference, null)) {
                tmpGeo2 = GeometryEngine.simplify((Geometry)tmpGeo2, (SpatialReference)spatialReference);
            }
            return (resultGeoemtry = GeometryEngine.intersect((Geometry)tmpGeo1, (Geometry)tmpGeo2, null)) != null ? GeometryEngine.geometryToWkt((Geometry)resultGeoemtry, (int)0) : "";
        }
        catch (Exception e) {
            throw new RuntimeException("ags service intersection error: " + e.getLocalizedMessage());
        }
    }

    public String difference(String geometry1, String substractor, String sr) {
        Geometry resultGeometry;
        Geometry tmpGeo1 = GeometryEngine.geometryFromWkt((String)geometry1, (int)0, (Geometry.Type)Geometry.Type.Unknown);
        Geometry tmpGeo2 = GeometryEngine.geometryFromWkt((String)substractor, (int)0, (Geometry.Type)Geometry.Type.Unknown);
        SpatialReference spatialReference = SpatialReference.create((String)sr);
        OperatorSimplify operatorSimplify = (OperatorSimplify)this.operatorFactory.getOperator(Operator.Type.Simplify);
        if (!operatorSimplify.isSimpleAsFeature(tmpGeo1, spatialReference, null)) {
            tmpGeo1 = GeometryEngine.simplify((Geometry)tmpGeo1, (SpatialReference)spatialReference);
        }
        if (!operatorSimplify.isSimpleAsFeature(tmpGeo2, spatialReference, null)) {
            tmpGeo2 = GeometryEngine.simplify((Geometry)tmpGeo2, (SpatialReference)spatialReference);
        }
        return (resultGeometry = GeometryEngine.difference((Geometry)tmpGeo1, (Geometry)tmpGeo2, null)) != null ? GeometryEngine.geometryToWkt((Geometry)resultGeometry, (int)0) : null;
    }

    public String union(String[] geometries, String sr) {
        Geometry[] geos = new Geometry[geometries.length];
        for (int i = 0; i < geometries.length; ++i) {
            Geometry geometry;
            String wkt = geometries[i];
            geos[i] = geometry = GeometryEngine.geometryFromWkt((String)wkt, (int)0, (Geometry.Type)Geometry.Type.Unknown);
        }
        Geometry resultGeometry = GeometryEngine.union((Geometry[])geos, null);
        return resultGeometry != null ? GeometryEngine.geometryToWkt((Geometry)resultGeometry, (int)0) : null;
    }

    public Double getGeometryArea(String wkt) {
        Geometry geometry = GeometryEngine.geometryFromWkt((String)wkt, (int)0, (Geometry.Type)Geometry.Type.Unknown);
        if (geometry != null) {
            if (geometry.getType().compareTo((Enum)Geometry.Type.Polygon) == 0) {
                return geometry.calculateArea2D();
            }
            return geometry.calculateLength2D();
        }
        return 0.0;
    }

    public boolean validGeometry(String wktGeometry, Object sr) {
        try {
            Geometry geo = GeometryEngine.geometryFromWkt((String)wktGeometry, (int)0, (Geometry.Type)Geometry.Type.Unknown);
            OperatorFactoryLocal factory = OperatorFactoryLocal.getInstance();
            OperatorSimplify operatorSimplify = (OperatorSimplify)factory.getOperator(Operator.Type.Simplify);
            SpatialReference targetSr = sr instanceof String ? SpatialReference.create((String)String.valueOf(sr)) : SpatialReference.create((int)Integer.valueOf(String.valueOf(sr)));
            return operatorSimplify.isSimpleAsFeature(geo, targetSr, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public String importShape(File shpFile) {
        FileInputStream fileInputStream = null;
        Object shapeBuffer = null;
        OperatorFactoryLocal factory = OperatorFactoryLocal.getInstance();
        OperatorExportToGeoJson operatorExportToGeoJson = (OperatorExportToGeoJson)factory.getOperator(Operator.Type.ExportToGeoJson);
        try {
            fileInputStream = new FileInputStream(shpFile);
            byte[] bytes = IOUtils.toByteArray((URI)shpFile.toURI());
            OperatorImportFromESRIShape operatorImportFromESRIShape = (OperatorImportFromESRIShape)factory.getOperator(Operator.Type.ImportFromESRIShape);
            Geometry geometry = operatorImportFromESRIShape.execute(0, Geometry.Type.Unknown, ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN));
            String string = geometry == null ? null : operatorExportToGeoJson.execute(geometry);
            return string;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception ex) {
                this.logger.error(ex.getLocalizedMessage());
            }
        }
    }
}

