package cn.gtmap.gtcc.support.web;

import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.RestControllerAdvice;

import java.util.HashMap;
import java.util.Map;

/**
 * 统一处理 rest 方法中的异常
 * 注:
 * ExceptionHandler 的优先级比 ControllerAdvice 高
 * 模块中自定义的 ExceptionHandler 会覆盖此类中的方法
 * 
 * @author <a href="mailto:yingxiufeng@gtmap.cn">alex.y</a>
 * @version v1.0, 2018/3/27 (c) Copyright gtmap Corp.
 */
@RestController
@ControllerAdvice
@RestControllerAdvice
public class GlobalExceptionHandler {

    /**
     * runtime exception
     * @param e
     * @return
     */
    @ExceptionHandler(RuntimeException.class)
    public Map handlerRuntimeException(final Exception e) {
        Map<String, Object> result = new HashMap<>();
        result.put("success", false);
        result.put("msg", e.getLocalizedMessage());
        return result;
    }

    /**
     * 参数验证
     * @param e
     * @return
     */
    @ExceptionHandler(MethodArgumentNotValidException.class)
    public Map handlerArgumentNotValid(final MethodArgumentNotValidException e){
        Map<String, Object> result = new HashMap<>();
        result.put("success", false);
        result.put("msg", e.getBindingResult().getFieldError().getDefaultMessage());
        return result;
    }
}
