package cn.gtmap.gtcc.properties.search;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * .ElasticSearchConfig
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2018/5/11 11:59
 */
@ConfigurationProperties(prefix = "app.search.elasticsearch")
public class ElasticSearchConfig {

    private String host;

    private int port;

    /**
     * http or https
     */
    private String scheme;

    public ElasticSearchConfig() {
    }

    public ElasticSearchConfig(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public ElasticSearchConfig(String host, int port, String scheme) {
        this.host = host;
        this.port = port;
        this.scheme = scheme;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getScheme() {
        return scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }
}
