package cn.gtmap.gtcc.domain.storage;

import cn.gtmap.gtcc.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;

import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;

/**
 * .Thumbnail
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/10/9 15:20
 */
@Entity
@Table(name = "gt_thumbnail")
public class Thumbnail extends BaseEntity {

    private String storageId;

    private int width;

    private int height;

    private long fileSize;

    private String path;

    public Thumbnail() {
    }

    public Thumbnail(String storageId, int width, int height) {
        this.storageId = storageId;
        this.width = width;
        this.height = height;
    }

    public String getStorageId() {
        return storageId;
    }

    public Thumbnail setStorageId(String storageId) {
        this.storageId = storageId;
        return this;
    }

    public int getWidth() {
        return width;
    }

    public Thumbnail setWidth(int width) {
        this.width = width;
        return this;
    }

    public int getHeight() {
        return height;
    }

    public Thumbnail setHeight(int height) {
        this.height = height;
        return this;
    }

    public long getFileSize() {
        return fileSize;
    }

    public Thumbnail setFileSize(long fileSize) {
        this.fileSize = fileSize;
        return this;
    }

    @JsonIgnore
    public String getPath() {
        return path;
    }

    public Thumbnail setPath(String path) {
        this.path = path;
        return this;
    }

    @Transient
    public String getThumbnailName() {
        return storageId + "_" + width + "_" + height;
    }
}
