package cn.gtmap.gtcc.domain.storage;

import cn.gtmap.gtcc.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;

import javax.persistence.*;
import java.util.List;

/**
 * .Storage
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/10/9 15:16
 */
@Entity
@Table(name = "gt_storage", indexes = {
        @Index(columnList = "name", name = "storage_name_idx"),
        @Index(columnList = "fileType", name = "storage_type_idx")
})
public class Storage extends BaseEntity {

    private String name;

    private String path;

    private long fileSize;

    private String fileType;

    private Storage parent;

    private List<Storage> children;

    private List<Node> nodes;

    public String getName() {
        return name;
    }

    public Storage setName(String name) {
        this.name = name;
        return this;
    }

    @JsonIgnore
    public String getPath() {
        return path;
    }

    public Storage setPath(String path) {
        this.path = path;
        return this;
    }

    public long getFileSize() {
        return fileSize;
    }

    public Storage setFileSize(long fileSize) {
        this.fileSize = fileSize;
        return this;
    }

    public String getFileType() {
        return fileType;
    }

    public Storage setFileType(String fileType) {
        this.fileType = fileType;
        return this;
    }

    @JsonIgnore
    @ManyToOne
    @JoinColumn(name = "parent")
    public Storage getParent() {
        return parent;
    }

    public Storage setParent(Storage parent) {
        this.parent = parent;
        return this;
    }

    @JsonIgnore
    @OneToMany(mappedBy = "parent")
    public List<Storage> getChildren() {
        return children;
    }

    public Storage setChildren(List<Storage> children) {
        this.children = children;
        return this;
    }

    @JsonIgnore
    @ManyToMany
    @JoinTable(name = "gt_node_storage_ref", joinColumns = @JoinColumn(name = "storage_id"), inverseJoinColumns = @JoinColumn(name = "node_id"))
    public List<Node> getNodes() {
        return nodes;
    }

    public void setNodes(List<Node> nodes) {
        this.nodes = nodes;
    }
}
