package cn.gtmap.gtcc.domain.storage;

import cn.gtmap.gtcc.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;

import javax.persistence.*;
import java.util.List;

/**
 * Created by fanyoudu on 2017/10/12.
 */
@Entity
@Table(name = "gt_node", indexes = {
        @Index(columnList = "name", name = "node_name_idx"),
        @Index(columnList = "type", name = "node_type_idx")
})
public class Node extends BaseEntity {

    private String name;

    private String alias;

    private String icon;

    /**
     * region:行政区
     */
    private String type;

    private String description;

    private String owner;

    private Node parent;

    private List<Node> children;

    private List<Storage> storages;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Column(nullable = false)
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOwner() {
        return owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @JsonIgnore
    @ManyToOne
    @JoinColumn(name = "parent")
    public Node getParent() {
        return parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    @JsonIgnore
    @OneToMany(mappedBy = "parent")
    public List<Node> getChildren() {
        return children;
    }

    public void setChildren(List<Node> children) {
        this.children = children;
    }

    @JsonIgnore
    @ManyToMany
    @JoinTable(name = "gt_node_storage_ref", joinColumns = @JoinColumn(name = "node_id"), inverseJoinColumns = @JoinColumn(name = "storage_id"))
    public List<Storage> getStorages() {
        return storages;
    }

    public void setStorages(List<Storage> storages) {
        this.storages = storages;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }
}
