package cn.gtmap.gtcc.domain.sec;

import cn.gtmap.gtcc.domain.ID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import javax.persistence.*;
import java.util.Date;

/**
 * .UserInfo
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/9/21 14:29
 */
@JsonIgnoreProperties({"hibernateLazyInitializer", "handler"})
@Entity
@Table(name = "gt_user_info")
public class UserInfo extends ID{

    private Date birthday;

    private String avatar;

    private String email;

    private String mobile;

    private String tel;

    private String address;

    private String zipCode;

    private String description;

    private User user;

    public UserInfo() {
    }

    public UserInfo(Date birthday, String avatar, String email, String mobile, String tel, String address, String zipCode, String description) {
        this.birthday = birthday;
        this.avatar = avatar;
        this.email = email;
        this.mobile = mobile;
        this.tel = tel;
        this.address = address;
        this.zipCode = zipCode;
        this.description = description;
    }

    public Date getBirthday() {
        return birthday;
    }

    public UserInfo setBirthday(Date birthday) {
        this.birthday = birthday;
        return this;
    }

    public String getAvatar() {
        return avatar;
    }

    public UserInfo setAvatar(String avatar) {
        this.avatar = avatar;
        return this;
    }

    public String getEmail() {
        return email;
    }

    public UserInfo setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getMobile() {
        return mobile;
    }

    public UserInfo setMobile(String mobile) {
        this.mobile = mobile;
        return this;
    }

    public String getTel() {
        return tel;
    }

    public UserInfo setTel(String tel) {
        this.tel = tel;
        return this;
    }

    public String getAddress() {
        return address;
    }

    public UserInfo setAddress(String address) {
        this.address = address;
        return this;
    }

    public String getZipCode() {
        return zipCode;
    }

    public UserInfo setZipCode(String zipCode) {
        this.zipCode = zipCode;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public UserInfo setDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonIgnore
    @OneToOne(mappedBy = "userInfo")
    @PrimaryKeyJoinColumn
    public User getUser() {
        return user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public String toString() {
        return "UserInfo{" +
                "birthday=" + birthday +
                ", avatar='" + avatar + '\'' +
                ", email='" + email + '\'' +
                ", mobile='" + mobile + '\'' +
                ", tel='" + tel + '\'' +
                ", address='" + address + '\'' +
                ", zipCode='" + zipCode + '\'' +
                ", description='" + description + '\'' +
                '}';
    }
}
