package cn.gtmap.gtcc.domain.sec;

import cn.gtmap.gtcc.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.util.List;

/**
 * .User
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/9/21 13:51
 */
@Entity
@Table(name = "gt_user", indexes = {
        @Index(columnList = "username", name = "user_username_idx", unique = true)
})
//@DynamicUpdate
public class User extends BaseEntity {
    /**
     * 用户名
     */
    private String username;
    /**
     * 密码
     */
    private String password;
    /**
     * 用户别名
     */
    private String alias;
    /**
     *是否过期
     */
    private boolean expired = false;
    /**
     *是否锁住
     */
    private boolean locked = false;
    /**
     *用户详细信息
     */
    private UserInfo userInfo;
    /**
     *关联角色
     */
    private List<Role> roles;
    /**
     *关联部门
     */
    private List<Department> departments;

    /**
     * 最大分析面积
     */
    private double maxAnalysisArea;

    @Column(length = 16, nullable = false)
    public String getUsername() {
        return username;
    }

    public User setUsername(String username) {
        this.username = username;
        return this;
    }

//    @JsonIgnore
    @Column(length = 80, nullable = false)
    public String getPassword() {
        return password;
    }

//    @JsonProperty
    public User setPassword(String password) {
        this.password = password;
        return this;
    }

    @Column(nullable = false)
    public String getAlias() {
        return alias;
    }

    public User setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public boolean isExpired() {
        return expired;
    }

    public User setExpired(boolean expired) {
        this.expired = expired;
        return this;
    }

    public boolean isLocked() {
        return locked;
    }

    public User setLocked(boolean locked) {
        this.locked = locked;
        return this;
    }

    @JsonIgnore
    @OneToOne(fetch = FetchType.LAZY)
    public UserInfo getUserInfo() {
        return userInfo;
    }

    @JsonProperty
    public User setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
        return this;
    }

    @ManyToMany
    @JoinTable(name = "gt_user_role_ref", joinColumns = @JoinColumn(name = "user_id"), inverseJoinColumns = @JoinColumn(name = "role_id"))
    public List<Role> getRoles() {
        return roles;
    }

    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    @ManyToMany
    @JoinTable(name = "gt_user_depart_ref", joinColumns = @JoinColumn(name = "user_id"), inverseJoinColumns = @JoinColumn(name = "department_id"))
    public List<Department> getDepartments() {
        return departments;
    }

    public void setDepartments(List<Department> departments) {
        this.departments = departments;
    }


    public double getMaxAnalysisArea() {
        return maxAnalysisArea;
    }

    public void setMaxAnalysisArea(double maxAnalysisArea) {
        this.maxAnalysisArea = maxAnalysisArea;
    }

    @Override
    public String toString() {
        return "User{" +
                "username='" + username + '\'' +
                ", alias='" + alias + '\'' +
                ", expired=" + expired +
                ", locked=" + locked +
                ", enabled=" + enabled +
                '}';
    }
}
