package cn.gtmap.gtcc.domain.sec;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by zgl on 2018-05-02.
 */
public class RoleViewBuilder {

    /**
     * build roleView by role
     *
     * @param role
     * @return
     */
    public RoleView build(final Role role) {
        if (role == null) {
            return null;
        }else {
            RoleView roleView = new RoleView();
            roleView.setId(role.getId());
            roleView.setAlias(role.getAlias());
            roleView.setName(role.getName());
            roleView.setOperations(roleView.getOperations());
            roleView.setUsers(role.getUsers());
            return roleView;
        }
    }

    /**
     * build menuViews by menus
     *
     * @param roles
     * @return
     */
    public List<RoleView> build(final List<Role> roles) {
        if (roles == null) {
            return new ArrayList<>();
        }else {
            List<RoleView> roleViewArrayList = new ArrayList<>();
            for (Role role : roles) {
                roleViewArrayList.add(build(role));
            }
            return roleViewArrayList;
        }
    }
}
