package cn.gtmap.gtcc.domain.sec;

import cn.gtmap.gtcc.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;

import javax.persistence.*;
import java.util.List;

/**
 * .Role
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/9/22 16:11
 */
@Entity
@Table(name = "gt_role",indexes = {
        @Index(columnList = "name", name = "role_name_idx", unique = true)
})
public class Role extends BaseEntity {
    /**
     * 角色名称
     */
    private String name;
    /**
     * 角色别名
     */
    private String alias;
    /**
     * 关联用户
     */
    private List<User> users;
    /**
     * 管理操作
     */
    private List<Operation> operations;


    /**
     * 最大分析面积
     */
    private double maxAnalysisArea;

    public double getMaxAnalysisArea() {
        return maxAnalysisArea;
    }

    public void setMaxAnalysisArea(double maxAnalysisArea) {
        this.maxAnalysisArea = maxAnalysisArea;
    }


    public Role() {
    }

    public Role(String name, String alias) {
        this.name = name;
        this.alias = alias;
    }

    public String getName() {
        return name;
    }

    public Role setName(String name) {
        this.name = name;
        return this;
    }

    public String getAlias() {
        return alias;
    }

    public Role setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    @JsonIgnore
    @ManyToMany(mappedBy = "roles")
    public List<User> getUsers() {
        return users;
    }

    public Role setUsers(List<User> users) {
        this.users = users;
        return this;
    }

    @JsonIgnore
    @ManyToMany(fetch = FetchType.EAGER)
    @JoinTable(name = "gt_role_opera_ref", joinColumns = @JoinColumn(name = "role_id"), inverseJoinColumns = @JoinColumn(name = "operation_id"))
    public List<Operation> getOperations() {
        return operations;
    }

    public Role setOperations(List<Operation> operations) {
        this.operations = operations;
        return this;
    }

}
