package cn.gtmap.gtcc.domain.sec;

import cn.gtmap.gtcc.domain.region.Region;
import cn.gtmap.gtcc.domain.resource.dto.resource.RegionView;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by zgl on 2018-04-10.
 */
public class RegionViewBuilder {

    public RegionView build(final Region region){
        if(region == null){
            return null;
        }else {
            RegionView regionView = new RegionView();
            regionView.setCode(region.getCode());
            regionView.setName(region.getName());
            regionView.setChildren(build(region.getChildren()));
            return regionView;
        }

    }
    public List<RegionView> build(List<Region> regionList){
        if(CollectionUtils.isEmpty(regionList)){
            return new ArrayList<>();
        }else {
            List<RegionView> regionViews = new ArrayList<>();
            for(Region region : regionList){
                regionViews.add(build(region));
            }
            return regionViews;
        }
    }
}
