package cn.gtmap.gtcc.domain.sec;

import cn.gtmap.gtcc.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;

import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import java.util.List;

/**
 * .Operation
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/9/22 19:09
 */
@Entity
@Table(name = "gt_operation", indexes = {
        @Index(columnList = "name", name = "operat_name_idx", unique = true)
})
public class Operation extends BaseEntity {
    /**
     * 操作名称
     */
    private String name;
    /**
     * 操作别名
     */
    private String alias;
    /**
     * 关联角色
     */
    private List<Role> roles;

    public String getName() {
        return name;
    }

    public Operation setName(String name) {
        this.name = name;
        return this;
    }

    public String getAlias() {
        return alias;
    }

    public Operation setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    @JsonIgnore
    @ManyToMany(mappedBy = "operations")
    public List<Role> getRoles() {
        return roles;
    }

    public Operation setRoles(List<Role> roles) {
        this.roles = roles;
        return this;
    }
}
