package cn.gtmap.gtcc.domain.sec;

import cn.gtmap.gtcc.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;

import javax.persistence.*;
import java.util.List;

/**
 * .Department
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/9/22 19:53
 */
@Entity
@Table(name = "gt_department", indexes = {
        @Index(columnList = "name", name = "depart_name_idx", unique = true)
})
public class Department extends BaseEntity {
    /**
     * 部门代码
     */
    private String code;
    /**
     * 部门名称
     */
    private String name;
    /**
     * 行政区
     */
    private String regionCode;
    /**
     * 部门描述
     */
    private String description;
    /**
     * 部门权重
     */
    private int weight = 0;
    /**
     *父部门
     */
    private Department parent;
    /**
     *子部门
     */
    private List<Department> children;
    /**
     *关联用户
     */
    private List<User> users;

    public String getName() {
        return name;
    }

    public Department setName(String name) {
        this.name = name;
        return this;
    }

    public String getCode() {
        return code;
    }

    public Department setCode(String code) {
        this.code = code;
        return this;
    }

    public String getRegionCode() {
        return regionCode;
    }

    public Department setRegionCode(String regionCode) {
        this.regionCode = regionCode;
        return this;
    }

    @JsonIgnore
    @ManyToOne
    @JoinColumn(name = "parent")
    public Department getParent() {
        return parent;
    }

    public Department setParent(Department parent) {
        this.parent = parent;
        return this;
    }

    @JsonIgnore
    @OneToMany(mappedBy = "parent")
    public List<Department> getChildren() {
        return children;
    }

    public Department setChildren(List<Department> children) {
        this.children = children;
        return this;
    }

    @JsonIgnore
    @ManyToMany(mappedBy = "departments")
    public List<User> getUsers() {
        return users;
    }

    public Department setUsers(List<User> users) {
        this.users = users;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public Department setDescription(String description) {
        this.description = description;
        return this;
    }

    public int getWeight() {
        return weight;
    }

    public Department setWeight(int weight) {
        this.weight = weight;
        return this;
    }
}
