package cn.gtmap.gtcc.domain.sec;

import cn.gtmap.gtcc.domain.BaseEntity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * .Client
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/9/25 9:18
 */
@Entity
@Table(name = "gt_client", indexes = {
        @Index(columnList = "clientId", name = "client_client_id_idx", unique = true)
})
public class Client extends BaseEntity {


    private String clientId;
    private String clientSecret;

    private String scopes;
    private String resourceIds;
    private String authorizedGrantTypes;
    private String registeredRedirectUris;
    private String autoApproveScopes;
    private String authorities;
    private Integer accessTokenValiditySeconds = 60 * 60 * 12;
    private Integer refreshTokenValiditySeconds = 60 * 60 * 24 * 30;
    private String additionalInfo = "{}";

    @Column(length = 16, nullable = false)
    public String getClientId() {
        return clientId;
    }

    public Client setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Column(length = 80, nullable = false)
    public String getClientSecret() {
        return clientSecret;
    }

    public Client setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public String getScopes() {
        return scopes;
    }

    public Client setScopes(String scopes) {
        this.scopes = scopes;
        return this;
    }

    public String getResourceIds() {
        return resourceIds;
    }

    public Client setResourceIds(String resourceIds) {
        this.resourceIds = resourceIds;
        return this;
    }

    public String getAuthorizedGrantTypes() {
        return authorizedGrantTypes;
    }

    /**
     * "client_credentials", "password","authorization_code", "refresh_token"
     *
     * @param authorizedGrantTypes
     * @return
     */
    public Client setAuthorizedGrantTypes(String authorizedGrantTypes) {
        this.authorizedGrantTypes = authorizedGrantTypes;
        return this;
    }

    public String getRegisteredRedirectUris() {
        return registeredRedirectUris;
    }

    public Client setRegisteredRedirectUris(String registeredRedirectUris) {
        this.registeredRedirectUris = registeredRedirectUris;
        return this;
    }

    public String getAutoApproveScopes() {
        return autoApproveScopes;
    }

    public Client setAutoApproveScopes(String autoApproveScopes) {
        this.autoApproveScopes = autoApproveScopes;
        return this;
    }

    public String getAuthorities() {
        return authorities;
    }

    public Client setAuthorities(String authorities) {
        this.authorities = authorities;
        return this;
    }

    public Integer getAccessTokenValiditySeconds() {
        return accessTokenValiditySeconds;
    }

    public Client setAccessTokenValiditySeconds(Integer accessTokenValiditySeconds) {
        this.accessTokenValiditySeconds = accessTokenValiditySeconds;
        return this;
    }

    public Integer getRefreshTokenValiditySeconds() {
        return refreshTokenValiditySeconds;
    }

    public Client setRefreshTokenValiditySeconds(Integer refreshTokenValiditySeconds) {
        this.refreshTokenValiditySeconds = refreshTokenValiditySeconds;
        return this;
    }

    public String getAdditionalInfo() {
        return additionalInfo;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }
}
