package cn.gtmap.gtcc.domain.sec;

import cn.gtmap.gtcc.domain.BaseEntity;
import cn.gtmap.gtcc.domain.core.Type;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * .Authority
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/9/29 20:51
 */
@Entity
@Table(name = "gt_authority", indexes = {
        @Index(columnList = "username", name = "auth_username_idx"),
        @Index(columnList = "type", name = "auth_type_idx")
})
public class Authority extends BaseEntity implements Type{

    private String username;

    private String authority;

    private String type;

    @Column(nullable = false, updatable = false, length = 16)
    public String getUsername() {
        return username;
    }

    public Authority setUsername(String username) {
        this.username = username;
        return this;
    }

    @Column(nullable = false, length = 256)
    public String getAuthority() {
        return authority;
    }

    public Authority setAuthority(String authority) {
        this.authority = authority;
        return this;
    }

    @Column(nullable = false, length = 16)
    public String getType() {
        return type;
    }

    public Authority setType(String type) {
        this.type = type;
        return this;
    }
}
