package cn.gtmap.gtcc.domain.resource.metadata.source;

import cn.gtmap.gtcc.domain.BaseEntity;
import cn.gtmap.gtcc.domain.core.Type;
import cn.gtmap.gtcc.domain.core.Url;

import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;

/**
 * .DataBase
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/11/9 9:39
 */
@Entity
@Table(name = "gt_database", indexes = {
        @Index(columnList = "dbName", name = "database_db_name_idx"),
        @Index(columnList = "type", name = "database_type_idx")
})
public class DataBase extends BaseEntity implements Type, Url {

    private DataBaseType dataBaseType;

    private String url;

    private String ip;

    private int port;

    private String username;

    private String password;

    private String dbName;

    private String tableName;

    private String driverClass;

    private String fields;

    @Transient
    private String queryTableSql;
    @Transient
    private String queryFieldSql;

    @Transient
    private String pageSql;
    /**
     * sid service
     */
    private String type;

    public DataBaseType getDataBaseType() {
        return dataBaseType;
    }

    public DataBase setDataBaseType(DataBaseType dataBaseType) {
        this.dataBaseType = dataBaseType;
        return this;
    }

    public String getUrl() {
        return url;
    }

    public DataBase setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getIp() {
        return ip;
    }

    public DataBase setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public int getPort() {
        return port;
    }

    public DataBase setPort(int port) {
        this.port = port;
        return this;
    }

    public String getUsername() {
        return username;
    }

    public DataBase setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return password;
    }

    public DataBase setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getDbName() {
        return dbName;
    }

    public DataBase setDbName(String dbName) {
        this.dbName = dbName;
        return this;
    }

    public String getTableName() {
        return tableName;
    }

    public DataBase setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    @Override
    public String getType() {
        return type;
    }

    public DataBase setType(String type) {
        this.type = type;
        return this;
    }

    public String getDriverClass() {
        return driverClass;
    }

    public DataBase setDriverClass(String driverClass) {
        this.driverClass = driverClass;
        return this;
    }

    public String getQueryTableSql() {
        return queryTableSql;
    }

    public DataBase setQueryTableSql(String queryTableSql) {
        this.queryTableSql = queryTableSql;
        return this;
    }

    public String getQueryFieldSql() {
        return queryFieldSql;
    }

    public DataBase setQueryFieldSql(String queryFieldSql) {
        this.queryFieldSql = queryFieldSql;
        return this;
    }

    public String getFields() {
        return fields;
    }

    public DataBase setFields(String fields) {
        this.fields = fields;
        return this;
    }

    public String getPageSql() {
        return pageSql;
    }

    public DataBase setPageSql(String pageSql) {
        this.pageSql = pageSql;
        return this;
    }
}
