package cn.gtmap.gtcc.domain.resource.metadata;

import cn.gtmap.gtcc.domain.ID;
import com.fasterxml.jackson.annotation.JsonIgnore;

import javax.persistence.*;

/**
 * .SpatialCoverage
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/11/7 15:02
 */
@Entity
@Table(name = "gt_spatial_coverage")
public class SpatialCoverage extends ID {

    private double left;
    private double bottom;
    private double right;
    private double top;

    private int wkid;

    private String wkt;

    private Resource resource;

    @Column(name = "l")
    public double getLeft() {
        return left;
    }

    public SpatialCoverage setLeft(double left) {
        this.left = left;
        return this;
    }

    @Column(name = "b")
    public double getBottom() {
        return bottom;
    }

    public SpatialCoverage setBottom(double bottom) {
        this.bottom = bottom;
        return this;
    }

    @Column(name = "r")
    public double getRight() {
        return right;
    }

    public SpatialCoverage setRight(double right) {
        this.right = right;
        return this;
    }

    @Column(name = "t")
    public double getTop() {
        return top;
    }

    public SpatialCoverage setTop(double top) {
        this.top = top;
        return this;
    }

    public int getWkid() {
        return wkid;
    }

    public SpatialCoverage setWkid(int wkid) {
        this.wkid = wkid;
        return this;
    }

    public String getWkt() {
        return wkt;
    }

    public SpatialCoverage setWkt(String wkt) {
        this.wkt = wkt;
        return this;
    }

    @JsonIgnore
    @OneToOne(mappedBy = "spatialCoverage")
    @PrimaryKeyJoinColumn
    public Resource getResource() {
        return resource;
    }

    public SpatialCoverage setResource(Resource resource) {
        this.resource = resource;
        return this;
    }

    //覆盖区域
    @Column(name="coverageArea")
    private String coverageArea;

    public String getCoverageArea() {
        return coverageArea;
    }

    public void setCoverageArea(String coverageArea) {
        this.coverageArea = coverageArea;
    }
}
