package cn.gtmap.gtcc.domain.resource.metadata;

import cn.gtmap.gtcc.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;

import javax.persistence.*;

/**
 * .Responsible
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/11/17 9:24
 */
@Entity
@Table(name = "gt_responsible")
public class Responsible extends BaseEntity {

    /**
     * 单位名称
     */
    private String orgnizationName;

    /**
     * 责任人
     */
    private String principal;

    /**
     * 地址
     */
    private String address;

    /**
     * 电话
     */
    private String tel;

    /**
     * 传真
     */
    private String fax;

    private Resource resource;

    public String getOrgnizationName() {
        return orgnizationName;
    }

    public Responsible setOrgnizationName(String orgnizationName) {
        this.orgnizationName = orgnizationName;
        return this;
    }

    public String getPrincipal() {
        return principal;
    }

    public Responsible setPrincipal(String principal) {
        this.principal = principal;
        return this;
    }

    public String getAddress() {
        return address;
    }

    public Responsible setAddress(String address) {
        this.address = address;
        return this;
    }

    public String getTel() {
        return tel;
    }

    public Responsible setTel(String tel) {
        this.tel = tel;
        return this;
    }

    public String getFax() {
        return fax;
    }

    public Responsible setFax(String fax) {
        this.fax = fax;
        return this;
    }

    @JsonIgnore
    @OneToOne(mappedBy = "responsible")
    @PrimaryKeyJoinColumn
    public Resource getResource() {
        return resource;
    }

    public Responsible setResource(Resource resource) {
        this.resource = resource;
        return this;
    }
}
