package cn.gtmap.gtcc.domain.resource.metadata;

import cn.gtmap.gtcc.domain.BaseEntity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;


/**
 * resource apply
 *
 * @author monarchCheng
 * @create 2017-11-10 13:45
 **/
@Entity
@Table(name = "gt_resource_apply")
public class ResourceApply extends BaseEntity {
    /**
     * 任务id
     */
    private String taskId;

    /**
     * 流程id
     */
    private String processId;
    /**
     * 资源描述
     */
    private String description;
    /**
     * 资源标题
     */
    private String title;
    /**
     * 申请者别名
     */
    private String applicant;

    /**
     * 申请者登录名
     */
    private String applicantName;

    /**
     * 申请数据
     */
    private String applicationData;

    /**
     * 部门
     */
    private String department;
    /**
     * 审核者
     */
    private String auditor;
    /**
     * 申请理由
     */
    private String applyReason;
    /**
     * 资源id
     */
    private String resourceId;

    /**
     * 资源能力id，多个以逗号
     */
    private String capables;
    /**
     * 审批意见
     */
    private String option;
    /**
     * 审批状态
     */
    private String agree;
    /**
     * 资源类型
     */
    private String type;
    /**
     * 操作时间
     */
    private Date operateTime;
    /**
     * 缩略图
     */
    private String icon;

    public String getDepartment() {
        return department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getDescription() {
        return description;
    }

    public ResourceApply setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getApplicant() {
        return applicant;
    }

    public ResourceApply setApplicant(String applicant) {
        this.applicant = applicant;
        return this;
    }


    public String getAuditor() {
        return auditor;
    }

    public ResourceApply setAuditor(String auditor) {
        this.auditor = auditor;
        return this;
    }

    public String getResourceId() {
        return resourceId;
    }

    public ResourceApply setResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }


    public String getCapables() {
        return capables;
    }

    public void setCapables(String capables) {
        this.capables = capables;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getApplyReason() {
        return applyReason;
    }

    public void setApplyReason(String applyReason) {
        this.applyReason = applyReason;
    }

    @Column(name = "_option")
    public String getOption() {
        return option;
    }

    public void setOption(String option) {
        this.option = option;
    }

    public String getAgree() {
        return agree;
    }

    public void setAgree(String agree) {
        this.agree = agree;
    }

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Date getOperateTime() {
        return operateTime;
    }

    public void setOperateTime(Date operateTime) {
        this.operateTime = operateTime;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getProcessId() {
        return processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }


    public String getApplicantName() {
        return applicantName;
    }

    public void setApplicantName(String applicantName) {
        this.applicantName = applicantName;
    }

    public String getApplicationData() {
        return applicationData;
    }

    public void setApplicationData(String applicationData) {
        this.applicationData = applicationData;
    }

}
