package cn.gtmap.gtcc.domain.resource.metadata;

import cn.gtmap.gtcc.domain.BaseEntity;
import cn.gtmap.gtcc.domain.core.TimeCoverage;
import cn.gtmap.gtcc.domain.core.Title;
import cn.gtmap.gtcc.domain.core.Type;
import com.fasterxml.jackson.annotation.JsonIgnore;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

/**
 * .Resource
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/11/4 14:12
 */
@Entity
@Table(name = "gt_resource", indexes = {
        @Index(columnList = "title", name = "res_title_idx"),
        @Index(columnList = "type", name = "res_type_idx"),
        @Index(columnList = "creator", name = "res_creator_idx"),
        @Index(columnList = "publisher", name = "res_publisher_idx"),
        @Index(columnList = "spatial_coverage_id", name = "res_sp_co_idx")
})
public class Resource<T> extends BaseEntity implements Title, Type, TimeCoverage {

    /**
     * 标题
     */
    private String title;
    /**
     * 描述
     */
    private String description;
    /**
     * 关键字
     */
    private List<Keyword> keywords;
    /**
     * Collection
     * Dataset
     * Event
     * Image
     * InteractiveResource
     * MovingImage
     * Service
     * Software
     * Sound
     * Text
     */
    private String type;
    /**
     * Media MINE Type·
     */
    private String format;
    /**
     * 创建者
     */
    private String creator;
    /**
     * 发布者
     */
    private String publisher;

    /**
     * 时间范围，开始时间
     */
    private Date startAt;

    /**
     * 时间范围，结束时间
     */
    private Date endAt;

    /**
     * 空间覆盖范围
     */
    private SpatialCoverage spatialCoverage;

    /**
     * 关联资源，比如聚合拆分多资源关系体现
     */
    private List<Resource> relations;

    /**
     * 资源权限描述
     */
    private String rights;

    /**
     * 资源具体描述
     */
    private T source;

    /**
     * 归属资源目录
     */
    private List<Catalog> catalogs;

    /**
     * 资源能力
     *
     * @return
     */
    private List<Capable> capables;

    /**
     * 责任单位信息
     */
    private Responsible responsible;

    /**
     * 缩略图资源id
     */
    private String icon;

    /**
     * 行政区划
     */
    private String regionCode;

    /**
     * 资源权重
     */
    @Column(nullable = false, columnDefinition = "INT default 0")
    private Integer weight;

    /**
     * 注册资源(register)，下载资源(download)
     */
    @Column(nullable = true)
    private String status;

    //使用权限
    //公开(1)，不公开(2)
    @Column(name = "permission")
    private String permission;
    //更新周期
    @Column(name = "resourceGxzq")
    private String resourceGxzq;

    public String getResourceGxzq() {
        return resourceGxzq;
    }

    public void setResourceGxzq(String resourceGxzq) {
        this.resourceGxzq = resourceGxzq;
    }

    public String getPermission() {
        return permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }


    @Override
    public String getTitle() {
        return title;
    }

    public Resource setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public Resource setDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonIgnore
    @ManyToMany
    @JoinTable(name = "gt_res_kw_ref", joinColumns = @JoinColumn(name = "resource_id"), inverseJoinColumns = @JoinColumn(name = "keyword_id"))
    public List<Keyword> getKeywords() {
        return keywords;
    }

    public Resource setKeywords(List<Keyword> keywords) {
        this.keywords = keywords;
        return this;
    }

    @Override
    public String getType() {
        return type;
    }

    public Resource setType(String type) {
        this.type = type;
        return this;
    }

    @Override
    public Date getEndAt() {
        return this.endAt;
    }

    public String getFormat() {
        return format;
    }

    public Resource setFormat(String format) {
        this.format = format;
        return this;
    }

    public String getCreator() {
        return creator;
    }

    public Resource setCreator(String creator) {
        this.creator = creator;
        return this;
    }

    public String getPublisher() {
        return publisher;
    }

    public Resource setPublisher(String publisher) {
        this.publisher = publisher;
        return this;
    }

    public Resource setEndAt(Date endAt) {
        this.endAt = endAt;
        return this;
    }

    @JsonIgnore
    @OneToOne(fetch = FetchType.LAZY, cascade = {CascadeType.ALL})
    public SpatialCoverage getSpatialCoverage() {
        return spatialCoverage;
    }

    public Resource setSpatialCoverage(SpatialCoverage spatialCoverage) {
        this.spatialCoverage = spatialCoverage;
        return this;
    }

    @JsonIgnore
    @ManyToMany
    @JoinTable(name = "gt_res_self_ref")
    public List<Resource> getRelations() {
        return relations;
    }

    public Resource setRelations(List<Resource> relations) {
        this.relations = relations;
        return this;
    }

    public String getRights() {
        return rights;
    }

    public Resource setRights(String rights) {
        this.rights = rights;
        return this;
    }

    @JsonIgnore
    @Basic(fetch = FetchType.LAZY)
    @org.hibernate.annotations.Type(type = "json")
    @Lob
    /*@Column(columnDefinition = "json")  mysql 5.7 支持 */
    public T getSource() {
        return source;
    }

    public Resource setSource(T source) {
        this.source = source;
        return this;
    }

    @JsonIgnore
    @ManyToMany(mappedBy = "resources", cascade = {CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    public List<Catalog> getCatalogs() {
        return catalogs;
    }

    public Resource setCatalogs(List<Catalog> catalogs) {
        this.catalogs = catalogs;
        return this;
    }

    @Override
    public Date getStartAt() {
        return startAt;
    }

    public void setStartAt(Date startAt) {
        this.startAt = startAt;
    }

    @JsonIgnore
    @OneToMany(mappedBy = "resource")
    public List<Capable> getCapables() {
        return capables;
    }

    public Resource setCapables(List<Capable> capables) {
        this.capables = capables;
        return this;
    }

    @JsonIgnore
    @OneToOne(fetch = FetchType.LAZY, cascade = {CascadeType.ALL})
    public Responsible getResponsible() {
        return responsible;
    }

    public void setResponsible(Responsible responsible) {
        this.responsible = responsible;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof Resource && getId().equals(((Resource) o).getId());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }


    public String getIcon() {
        return icon;
    }

    public Resource setIcon(String icon) {
        this.icon = icon;
        return this;
    }


    public String getRegionCode() {
        return regionCode;
    }

    public Resource setRegionCode(String regionCode) {
        this.regionCode = regionCode;
        return this;
    }

    public Integer getWeight() {
        return weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

}
