package cn.gtmap.gtcc.domain.resource.metadata;

import cn.gtmap.gtcc.domain.ID;
import cn.gtmap.gtcc.domain.core.Title;
import cn.gtmap.gtcc.domain.core.Type;
import com.fasterxml.jackson.annotation.JsonIgnore;

import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import java.util.List;

/**
 * .Keyword
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/11/4 16:15
 */
@Entity
@Table(name = "gt_keyword", indexes = {
        @Index(columnList = "title", name = "kw_title_idx", unique = true)
})
public class Keyword extends ID implements Title, Type {

    private String title;
    private String type;

    private List<Resource> resources;

    @Override
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonIgnore
    @ManyToMany(mappedBy = "keywords")
    public List<Resource> getResources() {
        return resources;
    }

    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }
}
