package cn.gtmap.gtcc.domain.resource.metadata;

import cn.gtmap.gtcc.domain.BaseEntity;
import cn.gtmap.gtcc.domain.core.Title;
import cn.gtmap.gtcc.domain.core.Type;
import com.fasterxml.jackson.annotation.JsonIgnore;

import javax.persistence.*;
import java.util.List;

/**
 * .Catalog
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/11/7 19:15
 */
@Entity
@Table(name = "gt_catalog", indexes = {
        @Index(columnList = "title", name = "cat_title_idx"),
        @Index(columnList = "type", name = "cat_type_idx")
})
public class Catalog extends BaseEntity implements Title, Type {

    private String title;
    private String description;
    private String type;
    private String code;

    private int weight;

    private Catalog parent;
    private List<Catalog> children;

    private List<Resource> resources;

    private String remark;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getTitle() {
        return title;
    }

    public Catalog setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public Catalog setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public String getType() {
        return type;
    }

    public Catalog setType(String type) {
        this.type = type;
        return this;
    }


    public int getWeight() {
        return weight;
    }

    public Catalog setWeight(int weight) {
        this.weight = weight;
        return this;
    }

//    @Override
    @JsonIgnore
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "parent_id")
    public Catalog getParent() {
        return parent;
    }

    public Catalog setParent(Catalog parent) {
        this.parent = parent;
        return this;
    }

    @JsonIgnore
    @OneToMany(mappedBy = "parent",cascade = CascadeType.ALL)
    @OrderBy("weight asc")
    public List<Catalog> getChildren() {
        return children;
    }

    public Catalog setChildren(List<Catalog> children) {
        this.children = children;
        return this;
    }

    @JsonIgnore
    @ManyToMany
    @JoinTable(name = "gt_cat_res_ref", joinColumns = @JoinColumn(name = "catalog_id"), inverseJoinColumns = @JoinColumn(name = "resource_id"))
    public List<Resource> getResources() {
        return resources;
    }

    public Catalog setResources(List<Resource> resources) {
        this.resources = resources;
        return this;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }


}
