package cn.gtmap.gtcc.domain.resource.dto.resource;

import cn.gtmap.gtcc.domain.resource.metadata.Resource;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by zgl on 2017-12-20.
 */
public class ResourceViewBuilder {

    /**
     * build ResourceView by resource
     *
     * @param resource
     * @return
     */
    public ResourceView build(final Resource resource) {
        if (resource == null) {
            return null;
        }else{
            ResourceView resourceView = new ResourceView();
            resourceView.setId(resource.getId());
            resourceView.setType(resource.getType());
            resourceView.setTitle(resource.getTitle());
            resourceView.setIcon(resource.getIcon());
            resourceView.setCapables(resource.getCapables());
            resourceView.setSpatialCoverage(resource.getSpatialCoverage());
            resourceView.setWeight(resource.getWeight());
            resourceView.setResourceViewList(build(resource.getRelations()));
            return resourceView;
        }
    }

    /**
     * build ResourceViewList by resourceList
     *
     * @param resourceList
     * @return
     */
    public List<ResourceView> build(final List<Resource> resourceList) {
        if (resourceList == null) {
            return new ArrayList<>();
        }else{
            List<ResourceView> resourceViewList = new ArrayList<>();
            for (Resource resource : resourceList) {
                resourceViewList.add(build(resource));
            }
            return resourceViewList;
        }
    }
}
