package cn.gtmap.gtcc.domain.resource.dto.resource;

import cn.gtmap.gtcc.domain.resource.metadata.Responsible;
import cn.gtmap.gtcc.domain.resource.metadata.SpatialCoverage;

import java.util.Date;
import java.util.List;

/**
 * resource view
 *
 * @author monarchCheng
 * @create 2017-11-13 15:56
 **/
public class ResourceView<T> {

    private String id;
    /**
     * 标题
     */
    private String title;
    /**
     * 描述
     */
    private String description;

    /**
     *
     */
    private Date createAt;

    /**
     * 更新时间
     */
    private Date updateAt;
    /**
     * 关键字
     */
    private List<String> keywordIds;

    /**
     * Collection
     * Dataset
     * Event
     * Image
     * InteractiveResource
     * MovingImage
     * Service
     * Software
     * Sound
     * Text
     */
    private String type;
    /**
     * Media MINE Type
     */
    private String format;
    /**
     * 创建者
     */
    private String creator;
    /**
     * 发布者
     */
    private String publisher;

    /**
     * 时间范围，开始时间
     */
    private Date startAt;

    /**
     * 时间范围，结束时间
     */
    private Date endAt;


    /**
     * 资源权限描述
     */
    private String rights;

    /**
     * 资源具体描述
     */
    private T source;

    /**
     * 缩略图地址
     */
    private String imgUrl;
    /**
     * 空间覆盖范围
     */
    private SpatialCoverage spatialCoverage;

    /**
     * 关联资源，比如聚合拆分多资源关系体现
     */
    private List<String> resourceIds;

    /**
     * 关联资源，比如聚合拆分多资源关系体现
     */
    private List<ResourceView> resourceViewList;

    /**
     * 归属资源目录
     */
    private List<String> catalogIds;
    /**
     * 行政机关
     */
    private List<String> xzjgIds;
    /**
     * 资源目录
     */
    private List<String> rescIds;
    /**
     * 资源能力id
     *
     * @return
     */
    private List<String> capableIds;


    /**
     * 资源能力
     */
    private List<CapableView> capables;


    /**
     * 缩略图id
     */
    private String icon;


    /**
     * 责任单位信息
     */
    private Responsible responsible;

    /**
     * 行政区划
     */
    private String regionCode;

    /**
     * 资源权重
     */
    private Integer weight;

    /**
     * 注册资源，下载资源
     */
    private String status;

    //使用权限
    private String permission;

    //投影类型
    private String projection;

    public String getProjection() {
        return projection;
    }

    public void setProjection(String projection) {
        this.projection = projection;
    }

    public String getPermission() {
        return permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    /**
     * 星级
     */
    private int rate;

    public int getRate() {
        return rate;
    }

    public void setRate(int rate) {
        this.rate = rate;
    }

    public List<String> getRescIds() {
        return rescIds;
    }

    public void setRescIds(List<String> rescIds) {
        this.rescIds = rescIds;
    }

    public List<String> getXzjgIds() {
        return xzjgIds;
    }

    public void setXzjgIds(List<String> xzjgIds) {
        this.xzjgIds = xzjgIds;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getKeywordIds() {
        return keywordIds;
    }

    public void setKeywordIds(List<String> keywordIds) {
        this.keywordIds = keywordIds;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getFormat() {
        return format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getPublisher() {
        return publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public Date getStartAt() {
        return startAt;
    }

    public void setStartAt(Date startAt) {
        this.startAt = startAt;
    }

    public Date getEndAt() {
        return endAt;
    }

    public void setEndAt(Date endAt) {
        this.endAt = endAt;
    }

    public String getRights() {
        return rights;
    }

    public void setRights(String rights) {
        this.rights = rights;
    }

    public T getSource() {
        return source;
    }

    public void setSource(T source) {
        this.source = source;
    }

    public SpatialCoverage getSpatialCoverage() {
        return spatialCoverage;
    }

    public void setSpatialCoverage(SpatialCoverage spatialCoverage) {
        this.spatialCoverage = spatialCoverage;
    }

    public List<String> getResourceIds() {
        return resourceIds;
    }

    public void setResourceIds(List<String> resourceIds) {
        this.resourceIds = resourceIds;
    }

    public List<String> getCatalogIds() {
        return catalogIds;
    }

    public void setCatalogIds(List<String> catalogIds) {
        this.catalogIds = catalogIds;
    }

    public List<String> getCapableIds() {
        return capableIds;
    }

    public void setCapableIds(List<String> capableIds) {
        this.capableIds = capableIds;
    }

    public List<CapableView> getCapables() {
        return capables;
    }

    public void setCapables(List<CapableView> capables) {
        this.capables = capables;
    }


    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public Date getCreateAt() {
        return createAt;
    }

    public void setCreateAt(Date createAt) {
        this.createAt = createAt;
    }

    public Responsible getResponsible() {
        return responsible;
    }

    public void setResponsible(Responsible responsible) {
        this.responsible = responsible;
    }

    public Date getUpdateAt() {
        return updateAt;
    }

    public void setUpdateAt(Date updateAt) {
        this.updateAt = updateAt;
    }

    public String getRegionCode() {
        return regionCode;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public Integer getWeight() {
        return weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }


    public List<ResourceView> getResourceViewList() {
        return resourceViewList;
    }

    public void setResourceViewList(List<ResourceView> resourceViewList) {
        this.resourceViewList = resourceViewList;
    }

}
