package cn.gtmap.gtcc.domain.resource.dto.resource;

import cn.gtmap.gtcc.domain.sec.Department;
import cn.gtmap.gtcc.domain.sec.DepartmentView;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by zgl on 2018-06-26.
 */
public class DepartmentViewBuilder {
    /**
     * build departmentView by department
     *
     * @param department
     * @return
     */
    public DepartmentView build(final Department department) {
        if (department == null) {
            return null;
        }else {
            DepartmentView departmentView = new DepartmentView();
            departmentView.setCode(department.getCode());
            departmentView.setId(department.getId());
            departmentView.setName(department.getName());
            departmentView.setRegionCode(department.getRegionCode());
            departmentView.setDescription(department.getDescription());
            departmentView.setWeight(departmentView.getWeight());
            return departmentView;
        }
    }

    /**
     * build departmentViewList by departments
     *
     * @param departments
     * @return
     */
    public List<DepartmentView> build(final List<Department> departments) {
        if (departments == null) {
            return new ArrayList<>();
        }else {
            List<DepartmentView> departmentViewList = new ArrayList<>();
            for (Department department : departments) {
                departmentViewList.add(build(department));
            }
            return departmentViewList;
        }
    }
}
