package cn.gtmap.gtcc.domain.resource.dto.resource;

import cn.gtmap.gtcc.domain.core.TreeNode;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.util.List;

/**
 * catalog view
 *
 * @author monarchCheng
 * @create 2017-11-23 8:58
 **/
public class CatalogView implements TreeNode<CatalogView> {

    private String id;
    private String title;
    private String description;
    private String type;
    private String code;


    private int weight;

    private CatalogView parent;
    private List<CatalogView> children;
    private List<ResourceView> resources;

    private String remark;

    public String getCode() {
        return code;
    }

    public CatalogView setCode(String code) {
        this.code = code;
        return this;
    }


    public String getId() {
        return id;
    }

    public CatalogView setId(String id) {
        this.id = id;
        return this;
    }

    public String getTitle() {
        return title;
    }

    public CatalogView setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public CatalogView setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getType() {
        return type;
    }

    public CatalogView setType(String type) {
        this.type = type;
        return this;
    }

    public int getWeight() {
        return weight;
    }

    public CatalogView setWeight(int weight) {
        this.weight = weight;
        return this;
    }

    public CatalogView setParent(CatalogView parent) {
        this.parent = parent;
        return this;
    }

    public CatalogView setChildren(List<CatalogView> children) {
        this.children = children;
        return this;
    }

    public CatalogView setResources(List<ResourceView> resources) {
        this.resources = resources;
        return this;
    }

    public List<ResourceView> getResources() {
        return resources;
    }

    @Override
    public CatalogView getParent() {
        return this.parent;
    }

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @Override
    public List<CatalogView> getChildren() {
        return this.children;
    }

    @Override
    public CatalogView getChild(int index) {
        return getChildren().get(index);
    }

    @Override
    public CatalogView getFirst() {
        return null;
    }

    @Override
    public CatalogView getLast() {
        return null;
    }

    @Override
    public int getChildrenCount() {
        return getChildren() != null ? getChildren().size() : 0;
    }

    @Override
    public boolean isRoot() {
        return parent == null;
    }

    @Override
    public boolean hasChildren() {
        return getChildrenCount() > 0;
    }

    public String getRemark() {
        return remark;
    }

    public CatalogView setRemark(String remark) {
        this.remark = remark;
        return this;
    }
}
