package cn.gtmap.gtcc.domain.resource.dto.resource;

import cn.gtmap.gtcc.domain.resource.metadata.Catalog;
import cn.gtmap.gtcc.utils.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;

/**
 * .CatalogViewBuilder
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/12/13 10:52
 */
public class CatalogBuilder {

    /**
     * build catalog by catalogView
     *
     * @param catalogView
     * @return
     */
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public Catalog build(final CatalogView catalogView) {
        if (catalogView == null) {
            return null;
        } else {
            Catalog catalog = new Catalog();
            catalog.setId(catalogView.getId());
            catalog.setTitle(catalogView.getTitle());
            catalog.setDescription(catalogView.getDescription());
            catalog.setType(catalogView.getType());
            Catalog parentCatalog = new Catalog();
            if(catalogView.getParent()!=null){
                BeanUtil.copyBean(catalogView.getParent(),parentCatalog);
                catalog.setParent(parentCatalog);
            }

            catalog.setWeight(catalogView.getWeight());
            catalog.setCode(catalogView.getCode());
            try {
                catalog.setChildren(build(catalogView.getChildren()));
            } catch (Exception e) {
                logger.error("catalog转换异常",e);
            }
            return catalog;
        }
    }

    /**
     * build catalogList by catalogViewList
     *
     * @param catalogViewList
     * @return
     */
    public List<Catalog> build(final List<CatalogView> catalogViewList) {
        if (catalogViewList == null) {
            return null;
        } else {
            List<Catalog> catalogList = new ArrayList<>();
            for (CatalogView catalogView : catalogViewList) {
                catalogList.add(build(catalogView));
            }
            return catalogList;
        }
    }
}
