package cn.gtmap.gtcc.domain.resource.dto.resource;

import cn.gtmap.gtcc.domain.resource.metadata.Capable;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Administrator
 *
 *CapableViewBuilder
 *  @data 2018-04-17 14:39:40
 */
public class CapableViewBuilder {

    /**
     * build capableView by capable
     *
     * @param capable
     * @return
     */
    public CapableView build(final Capable capable) {
        if (capable == null) {
            return null;
        }else {
            CapableView capableView = new CapableView();
            capableView.setCode(capable.getCode());
            capableView.setInfo(capable.getInfo());
            capableView.setUrl(capable.getUrl());
            capableView.setTitle(capable.getTitle());
            capableView.setStatus(capable.getStatus());
            capableView.setId(capable.getId());
            return capableView;
        }
    }

    /**
     * build CapableViews by capables
     *
     * @param capables
     * @return
     */
    public List<CapableView> build(final List<Capable> capables) {
        if (capables == null) {
            return new ArrayList<>();
        }else {
            List<CapableView> capableViewList = new ArrayList<>();
            for (Capable capable : capables) {
                capableViewList.add(build(capable));
            }
            return capableViewList;
        }
    }
}
