package cn.gtmap.gtcc.domain.resource.dto.resource;

import cn.gtmap.gtcc.domain.resource.metadata.CapableType;
import cn.gtmap.gtcc.domain.resource.metadata.Resource;


/**
 * capable view
 *
 * @author monarchCheng
 * @create 2017-11-17 15:07
 **/
public class CapableView<T> {

    private String title;

    private String proxyUrl;

    private String id;

    private String url;
    /**
     * 能力类型
     */
    private CapableType type;

    /**
     * 状态
     */
    private String status;

    /**
     *
     */
    private String code;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    /**
     * 能力相关配置信息
     */
    private T info;

    private boolean authorized;

    private String layerName;

    public Resource getResource() {
        return resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    private Resource resource;

    public String getTitle() {
        return title;
    }

    public CapableView setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getProxyUrl() {
        return proxyUrl;
    }

    public CapableView setProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
        return this;
    }

    public boolean isAuthorized() {
        return authorized;
    }

    public CapableView setAuthorized(boolean authorized) {
        this.authorized = authorized;
        return this;
    }


    public CapableType getType() {
        return type;
    }

    public CapableView setType(CapableType type) {
        this.type = type;
        return this;
    }

    public String getStatus() {
        return status;
    }

    public CapableView setStatus(String status) {
        this.status = status;
        return this;
    }

    public T getInfo() {
        return info;
    }

    public CapableView setInfo(T info) {
        this.info = info;
        return this;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    private ResourceView resourceView;

    public ResourceView getResourceView() {
        return resourceView;
    }

    public void setResourceView(ResourceView resourceView) {
        this.resourceView = resourceView;
    }


    public String getLayerName() {
        return layerName;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }
}
