package cn.gtmap.gtcc.domain.region;

import cn.gtmap.gtcc.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * .Region
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/10/16 14:20
 */
@Entity
@Table(name = "gt_region", indexes = {
        @Index(columnList = "code", name = "gt_region_code"),
        @Index(columnList = "name", name = "gt_region_name")
})
public class Region extends BaseEntity {

    private String code;
    private String name;
    private int level = 3;
    private int order = 0;
    private Date disableAt;

    private String shape;
    private Region parent;
    private List<Region> children = new ArrayList<>();

    @Column(length = 20, nullable = false)
    public String getCode() {
        return code;
    }

    public Region setCode(String code) {
        this.code = code;
        return this;
    }

    @Column(length = 100, nullable = false)
    public String getName() {
        return name;
    }

    public Region setName(String name) {
        this.name = name;
        return this;
    }

    @Column(precision = 1, scale = 0, nullable = false)
    public int getLevel() {
        return level;
    }

    public Region setLevel(int level) {
        this.level = level;
        return this;
    }

    @Column(name = "order_number", nullable = false)
    public int getOrder() {
        return order;
    }

    public Region setOrder(int order) {
        this.order = order;
        return this;
    }

    public Date getDisableAt() {
        return disableAt;
    }

    public Region setDisableAt(Date disableAt) {
        this.disableAt = disableAt;
        return this;
    }

    @Lob
    @Basic(fetch = FetchType.LAZY)
    public String getShape() {
        return shape;
    }

    public Region setShape(String shape) {
        this.shape = shape;
        return this;
    }

    @JsonIgnore
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "parent")
    public Region getParent() {
        return parent;
    }

    public Region setParent(Region parent) {
        this.parent = parent;
        return this;
    }
    @JsonIgnore
    @OneToMany(mappedBy = "parent",cascade = CascadeType.ALL)
    @OrderBy("order")
    public List<Region> getChildren() {
        return children;
    }

    public Region setChildren(List<Region> children) {
        this.children = children;
        return this;
    }
}
