package cn.gtmap.gtcc.domain.gis.tpl.map;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * .Widget
 *
 * @author <a href="mailto:yingxiufeng@gtmap.cn">alex.y</a>
 * @version v1.0, 2018/3/28 (c) Copyright gtmap Corp.
 */
@Data
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class Widget implements Comparable<Widget> {

    /**
     * id
     */
    private String id;

    /**
     * 功能位置
     */
    private String uri;

    /**
     * 功能标题
     */
    private String label;

    /**
     * 功能图标
     */
    private String iconCls;

    /**
     * 功能配置
     */
    private java.util.Map config;

    /**
     * 是否显示此功能
     */
    private boolean display;

    /**
     * 确定功能位置(多个widget时)
     */
    private int weight;

    @Override
    public int compareTo(Widget o) {
        return this.getWeight() - o.getWeight();
    }
}
