package cn.gtmap.gtcc.domain.gis.tpl.map;

import cn.gtmap.gtcc.domain.resource.dto.resource.Layer;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 资源服务
 * 可以是取自 resource
 *
 * @author <a href="mailto:yingxiufeng@gtmap.cn">alex.y</a>
 * @version v1.0, 2018/3/28 (c) Copyright gtmap Corp.
 * @see cn.gtmap.gtcc.domain.resource.metadata.Resource
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ResourceLayer implements Comparable<ResourceLayer> {

    /**
     * id
     * 取自资源时同资源 id
     */
    private String id;

    /**
     * 标题
     * 取自资源时同资源 title
     */
    private String title;

    /**
     * 服务类型
     * eg. ags_tile/ags_rest
     */
    private String type;

    /**
     * 服务地址
     */
    private String url;

    /**
     * 可见性
     */
    private boolean visible = true;

    /**
     * 透明度
     */
    private int alpha = 1;

    /**
     * 服务加载序号
     */
    private int index;

    /**
     * 缩略图
     */
    private String thumbnail;

    /**
     * 服务状态
     * 取自资源时同资源 status
     */
    private String status;

    /**
     * 自定义配置
     */
    private List<Object> config;
    /**
     * 图层
     */
    private List<Layer> layers;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isVisible() {
        return visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int getAlpha() {
        return alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public int getIndex() {
        return index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getThumbnail() {
        return thumbnail;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<Layer> getLayers() {
        return layers;
    }

    public void setLayers(List<Layer> layers) {
        this.layers = layers;
    }

    @Override
    public int compareTo(ResourceLayer o) {
        return this.getIndex() - o.getIndex();
    }

    public List<Object> getConfig() {
        return config;
    }

    public void setConfig(List<Object> config) {
        this.config = config;
    }
}
