package cn.gtmap.gtcc.domain.gis.tpl.map;

import cn.gtmap.gtcc.domain.core.Title;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.Lists;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * .Configuration
 *
 * @author <a href="mailto:yingxiufeng@gtmap.cn">alex.y</a>
 * @version v1.0, 2018/3/28 (c) Copyright gtmap Corp.
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class Configuration implements Title, Serializable {

    public Configuration() {
        tools = Lists.newArrayList();
        widgets = Lists.newArrayList();
        controls = Lists.newArrayList();
    }

    /**
     * 标题
     */
    private String title;

    /**
     * logo 路径
     */
    private String logo;

    /**
     * 地理服务地址
     */
    private String geometryService;

    /**
     * 是否显示头部
     */
    private Boolean isShowHeader;

    /**
     * 地理服务地址
     */
    private String fileImportService;

    /**
     * 图形校验地址
     */
    private String examineGeometryUrl;
    /**
     * region
     */
    private String regionIndex;
    /**
     * map
     */
    private Map map;

    /**
     * 地图 widgets
     */
    private List<Widget> widgets;


    /**
     * 地图 tools
     */
    private List<Widget> tools;


    /**
     * 地图样式控制
     */
    private String  widgetStyle;
    /**
     * 地图控制器 eg. zoomControl
     */
    private List<ControlWidget> controls;

    public static final class Map {

        private List<ResourceLayer> baseLayers;
        private List<ResourceLayer> layers;
        private java.util.Map options;

        public Map() {
            baseLayers = Lists.newArrayList();
            layers = Lists.newArrayList();
        }

        public List<ResourceLayer> getBaseLayers() {
            return baseLayers;
        }

        public void setBaseLayers(List<ResourceLayer> baseLayers) {
            this.baseLayers = baseLayers;
        }

        public List<ResourceLayer> getLayers() {
            return layers;
        }

        public void setLayers(List<ResourceLayer> layers) {
            this.layers = layers;
        }

        public java.util.Map getOptions() {
            return options;
        }

        public void setOptions(java.util.Map options) {
            this.options = options;
        }
    }


    @Override
    public String getTitle() {
        return this.title;
    }
}
