package cn.gtmap.gtcc.domain.gis.data.search;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import java.util.Date;

/**
 * Created by Fjj on 2017/11/27.
 */
@Entity
@Table(name = "gtcc_gis_import_task", uniqueConstraints = {
        @UniqueConstraint(columnNames = {"taskId"})
})
public class ImportDataTask {

    /**
     * 任务ID
     */
    @Id
    private String taskId;

    /**
     * 用户名
     */
    private String userName = "";

    /**
     * 任务接收主机的ip
     */
    private String host;

    /**
     * 索引名
     */
    private String index;

    /**
     * 文件类型（默认shapefile）
     * 目前包含shapefile、sde两种类型
     */
    private String fileType = "shapefile";

    /**
     * 文件资源地址
     */
    private String fileUrl;

    /**
     * 数据源
     */
    private String dataSource;

    /**
     * 表名
     */
    private String tableName;

    /**
     * 查询条件
     */
    private String wheres;

    /**
     * 描述信息（只在index不存在，需要创建index时使用）
     */
    private String comment = "";

    /**
     * 作为标题的字段
     */
    private String titleField = "";

    /**
     * 行政区划对应字段
     */
    private String xzqField = "";

    /**
     * 导入模式(0新建，1追加)
     */
    private String importMode = "0";

    /**
     * 导入类型(0 web，1 file system)
     */
    private String importType = "0";

    /**
     * 是否启用简化算法
     */
    private boolean simplify = false;

    /**
     * 距离阈值
     */
    private double distanceTolerance = 0.0;

    /**
     * 任务执行状态（0未执行，2已执行）
     */
    private int taskStatus = 0;

    /**
     * 执行结果信息
     */
    private String message;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 更新时间
     */
    private Date updateDate;

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getIndex() {
        return index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getFileType() {
        return fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getFileUrl() {
        return fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public String getDataSource() {
        return dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getWheres() {
        return wheres;
    }

    public void setWheres(String wheres) {
        this.wheres = wheres;
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getTitleField() {
        return titleField;
    }

    public void setTitleField(String titleField) {
        this.titleField = titleField;
    }

    public String getXzqField() {
        return xzqField;
    }

    public void setXzqField(String xzqField) {
        this.xzqField = xzqField;
    }

    public String getImportMode() {
        return importMode;
    }

    public void setImportMode(String importMode) {
        this.importMode = importMode;
    }

    public String getImportType() {
        return importType;
    }

    public void setImportType(String importType) {
        this.importType = importType;
    }

    public boolean isSimplify() {
        return simplify;
    }

    public void setSimplify(boolean simplify) {
        this.simplify = simplify;
    }

    public double getDistanceTolerance() {
        return distanceTolerance;
    }

    public void setDistanceTolerance(double distanceTolerance) {
        this.distanceTolerance = distanceTolerance;
    }

    public int getTaskStatus() {
        return taskStatus;
    }

    public void setTaskStatus(int taskStatus) {
        this.taskStatus = taskStatus;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }
}
