package cn.gtmap.gtcc.domain;

import cn.gtmap.gtcc.domain.core.Enable;
import cn.gtmap.gtcc.domain.core.Time;
import cn.gtmap.gtcc.support.hibernate.type.json.JsonBinaryType;
import cn.gtmap.gtcc.support.hibernate.type.json.JsonStringType;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.hibernate.annotations.*;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import java.util.Date;

/**
 * .BaseEntity
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/9/21 13:32
 */
@MappedSuperclass
@TypeDefs({
        @TypeDef(name = "json", typeClass = JsonStringType.class),
        @TypeDef(name = "jsonb", typeClass = JsonBinaryType.class)
})
@JsonIgnoreProperties({"hibernateLazyInitializer", "handler"})
public abstract class BaseEntity extends ID implements Time, Enable {

    private Date createAt;
    private Date updateAt;
    protected boolean enabled = true;

    @Temporal(TemporalType.TIMESTAMP)
    @CreationTimestamp
    @Column(updatable = false)
    public Date getCreateAt() {
        return createAt;
    }

    public void setCreateAt(Date createAt) {
        this.createAt = createAt;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public BaseEntity setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @UpdateTimestamp
    public Date getUpdateAt() {
        return updateAt;
    }

    public BaseEntity setUpdateAt(Date updateAt) {
        this.updateAt = updateAt;
        return this;
    }
}
