package cn.gtmap.gtcc.clients.workflow;

import cn.gtmap.gtcc.domain.workflow.*;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * workflow client
 *
 * @author monarchCheng
 * @create 2017-11-03 10:36
 **/
@FeignClient("workflow-app")
@RequestMapping("/workflow")
public interface WorkflowClient {

    /**
     * 通过key启动流程实例，若有相同key的流程定义则取最新version
     *
     * @param key
     * @param variables
     * @param businessKey
     * @return
     */
    @PostMapping("/process/key/{key}/start")
    String createProcessByKey(@PathVariable(name = "key") String key, @RequestBody Map variables, @RequestParam(required = false, name = "businessKey") String businessKey);

    /**
     * 根据id启动流程实例
     *
     * @param id
     * @param variables
     * @param businessKey
     * @return
     */
    @RequestMapping("/process/id/{id}/start")
    String startProcessById(@PathVariable(name = "id") String id, @RequestBody Map variables, @RequestParam(required = false, name = "businessKey") String businessKey);


    /**
     * 查询用户任务
     *
     * @param assignee
     * @return
     */
    @RequestMapping("/task/list")
    List<Task> getTaskList(@RequestParam(name = "assignee") String assignee);

    /**
     * 查询用户任务
     *
     * @param assignee
     * @param processDefinitionKey
     * @return
     */
    @RequestMapping("/task/list/{processDefinitionKey}")
    Page<Task> getTaskList(@RequestParam(name = "assignee") String assignee, @PathVariable(name = "processDefinitionKey") String processDefinitionKey,
                           Pageable pageable);

    /**
     * 查询用户任务
     *
     * @param assignee
     * @param processDefinitionKey
     * @param taskKey
     * @return
     */
    @GetMapping("/task/list/{processDefinitionKey}/{taskKey}")
    List<Task> getTaskList(@RequestParam(name = "assignee") String assignee,
                           @PathVariable(name = "processDefinitionKey") String processDefinitionKey,
                           @PathVariable(name = "taskKey") String taskKey);

    /**
     * 查询用户任务
     *
     * @param assignee
     * @param processDefinitionKey
     * @param taskKey
     * @return
     */
    @GetMapping("/task/page/{processDefinitionKey}/{taskKey}")
    Page<Task> getTaskPage(@RequestParam(name = "assignee") String assignee,
                           @PathVariable(name = "processDefinitionKey") String processDefinitionKey,
                           @PathVariable(name = "taskKey") String taskKey,
                           Pageable pageable);

    /**
     * 转发流程
     *
     * @param taskId
     * @param variables
     */
    @PostMapping("/process/transfer")
    void transferProcess(@RequestParam(name = "taskId") String taskId, @RequestBody Map variables);

    /**
     * 挂起流程
     *
     * @param processInstanceId
     */
    @RequestMapping("/process/suspend/{processInstanceId}")
    void suspendProcessInstance(@PathVariable(name = "processInstanceId") String processInstanceId);

    /**
     * 激活挂起流程
     *
     * @param processInstanceId
     */
    @RequestMapping("/process/active/{processInstanceId}")
    void activateProcessInstance(@PathVariable(name = "processInstanceId") String processInstanceId);

    /**
     * 删除流程
     *
     * @param processInstanceId
     * @param reason
     */
    @RequestMapping("/process/delete/{processInstanceId}")
    void deleteProcess(@PathVariable(name = "processInstanceId") String processInstanceId, @RequestParam(name = "reason") String reason);

    /**
     * 获取流程存储的变量
     *
     * @param processInstanceId
     * @return
     */
    @RequestMapping("/rest/process/variables/{processInstanceId}")
    Map<String, Object> getProcessVariables(@PathVariable(name = "processInstanceId") String processInstanceId);

    /**
     * 获取startForm
     *
     * @param processDefinitionId
     * @return
     */
    @RequestMapping("/rest/start/formData/{processDefinitionId}")
    List getStartFormData(@PathVariable(name = "processDefinitionId") String processDefinitionId);

    /**
     * 获取内置taskForm
     *
     * @param taskId
     * @return
     */
    @RequestMapping("/rest/task/formData/{taskId}")
    List getTaskFormData(@PathVariable(name = "taskId") String taskId);

    /**
     * 获取外置taskForm
     *
     * @param taskId
     * @return
     */
    @RequestMapping("/rest/task/rendered/formData/{taskId}")
    Object getRenderedTaskFormData(@PathVariable(name = "taskId") String taskId);

    /**
     * 提交startForm
     *
     * @param processDefinitionId
     * @param variables
     * @return
     */
    @RequestMapping("/startFormData/submit")
    Map<String, Object> submitStartFormData(@RequestParam(name = "processDefinitionId") String processDefinitionId, @RequestBody Map variables);

    /**
     * 提交taskForm
     *
     * @param taskId
     * @param variables
     */
    @RequestMapping("/taskFormData/submit")
    void submitTaskFormData(@RequestParam(name = "taskId") String taskId, @RequestBody Map variables);

    /**
     * 查询历史流程实例
     *
     * @param userName
     * @return
     */
    @RequestMapping("/rest/historyProcessInstance")
    Page<HistoricProcessInstance> findHistoryProcessInstance(@RequestParam(name = "userName") String userName, Pageable pageable);

    /**
     * 查询历史流程实例
     *
     * @param userName
     * @return
     */
    @RequestMapping("/rest/find/historyProcessInstance")
    HistoricProcessInstance findHistoryProcessInstance(@RequestParam(name = "userName") String userName);

    /**
     * 查询任务关联流程的businessKey 我的审批 未批
     *
     * @param taskId
     * @return
     */
    @GetMapping("/rest/process/businessKey/taskId")
    String findBusinessKeyByTaskId(@RequestParam(name = "taskId") String taskId);


    /**
     * 查询任务关联流程的businessKey 我的申请 未批
     *
     * @param taskId
     * @return
     */
    @GetMapping("/rest/process/businessKey/hisTaskId")
    String findBusinessKeyByHistoryTaskId(@RequestParam(name = "taskId") String taskId);


    /**
     * 查询任务的businessKey  已批
     *
     * @param taskId
     * @return
     */
    @GetMapping("/rest/hisprocess/businessKey/hisTaskId")
    String findHisBusinessKeyByTaskId(@RequestParam(name = "taskId") String taskId);


    /**
     * 查询历史流程实例节点
     *
     * @param processInstanceId
     * @return
     */
    @RequestMapping("/rest/find/historyActiviti/{processInstanceId}")
    List<HistoricActivityInstance> findHistoryActiviti(@PathVariable(name = "processInstanceId") String processInstanceId);

    /**
     * 查询历史流程实例中的任务
     *
     * @param taskAssignee
     * @return
     */
    @RequestMapping("/rest/find/historyTask")
    List<HistoricTaskInstance> findHistoryTask(@RequestParam(name = "taskAssignee") String taskAssignee);


    /**
     * 查询历史任务
     *
     * @param taskAssignee
     * @param processDefinitionKey
     * @return
     */
    @RequestMapping("/rest/find/historyTask/{taskAssignee}/{processDefinitionKey}")
    List<HistoricTaskInstance> findHistoryTask(@PathVariable(name = "taskAssignee") String taskAssignee, @PathVariable(name = "processDefinitionKey") String processDefinitionKey);


    /**
     * 查询历史任务
     *
     * @param taskAssignee
     * @param processDefinitionKey
     * @param taskDefinitionKey
     * @param finished
     * @param pageable
     * @return
     */
    @RequestMapping("/rest/find/historyTask/withKey")
    @ResponseBody
    Page<cn.gtmap.gtcc.domain.workflow.HistoricTaskInstance> findHistoryTask(@RequestParam(name = "taskAssignee") String taskAssignee,
                                                                             @RequestParam(name = "processDefinitionKey") String processDefinitionKey,
                                                                             @RequestParam(name = "taskDefinitionKey") String taskDefinitionKey,
                                                                             @RequestParam(name = "finished") boolean finished,
                                                                             Pageable pageable);

    /**
     * 查询历史流程变量
     *
     * @param processInstanceId
     * @return
     */
    @RequestMapping("/rest/find/historyProcessVariables/{processInstanceId}")
    List<HistoricVariableInstance> findHistoryProcessVariables(@PathVariable(name = "processInstanceId") String processInstanceId);

    /**
     * 创建流程模型
     *
     * @param name
     * @param key
     */
    @RequestMapping("/create/model")
    void createModel(@RequestParam(name = "name") String name, @RequestParam(name = "key") String key);

    /**
     * 根据模型发布流程定义
     *
     * @param processName
     * @param modelId
     * @return
     */
    @RequestMapping("/deploy/model")
    String deployModel(@RequestParam(name = "processName") String processName, @RequestParam(name = "modelId") String modelId);

    /**
     * 退回流程到任意节点
     *
     * @param taskId
     * @param activityId
     * @param variables
     */
    @PostMapping("/turnBack")
    void turnBack(@RequestParam(name = "taskId") String taskId, @RequestParam(name = "activityId") String activityId, @RequestBody Map variables);


    /**
     * find History Process
     *
     * @param taskAssignee
     * @param processDefinitionKey
     * @param taskDefinitionKey
     * @return
     */
    @GetMapping("/find/history/process")
    @ResponseBody
    Page<ProcessInstanceView> findHistoryProcess(@RequestParam(name = "taskAssignee") String taskAssignee,
                                                 @RequestParam(name = "processDefinitionKey") String processDefinitionKey,
                                                 @RequestParam(name = "taskDefinitionKey") String taskDefinitionKey,
                                                 Pageable pageable);


    /**
     * find resource apply
     *
     * @param state    checked/unchecked
     * @param role     applicant/auditor
     * @param userName user name
     * @param pageable
     * @return
     */
    @GetMapping("/res/apply/process")
    @ResponseBody
    Page<cn.gtmap.gtcc.domain.workflow.HistoricProcessInstance> findResApplyProcess(@RequestParam(name = "state") String state,
                                                                                    @RequestParam(name = "role") String role,
                                                                                    @RequestParam(name = "userName") String userName, Pageable pageable);

    @GetMapping("/res/findResApplyProcess")
    @ResponseBody
    public List<cn.gtmap.gtcc.domain.workflow.HistoricProcessInstance> findResApplyProcess(@RequestParam(name = "state") String state,
                                                                                           @RequestParam(name = "role") String role,
                                                                                           @RequestParam(name = "userName") String userName);

    @GetMapping("/res/applyYb")
    @ResponseBody
    public List<cn.gtmap.gtcc.domain.workflow.HistoricProcessInstance> applyYb(@RequestParam(name = "role") String role, @RequestParam(name = "userName") String userName);

    /**
     * query taskId
     *
     * @param taskKey
     * @param userName
     * @param processId
     * @return
     */
    @GetMapping("/query/taskId")
    @ResponseBody
    String queryTaskId(@RequestParam(name = "taskKey") String taskKey, @RequestParam(name = "userName") String userName, @RequestParam(name = "processId") String processId);

    /**
     * 根据流程的ID获取历史任务及其局部的属性
     */
    @GetMapping("/find/history/processHistory")
    @ResponseBody
    public List<HistoricTaskDesc> queryProcessHistory(@RequestParam(name = "processId") String processId);


    @GetMapping("/find/history/getBusinessKey")
    @ResponseBody
    String getBusinessKey (@RequestParam(name = "processId") String processId);
}
