package cn.gtmap.gtcc.clients.storage;

import cn.gtmap.gtcc.domain.storage.Storage;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 *
 * @author fanyoudu
 * @date 2017/11/9
 */
@FeignClient("storage-app")
@RequestMapping("/rest/storage")
public interface StorageClient {

    /**
     * file upload
     *
     * @param files
     * @return
     */
    @PostMapping(value = "/upload", produces = MediaType.APPLICATION_JSON_UTF8_VALUE, consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    Storage[] upload(@RequestPart(name = "file") MultipartFile files);

    @PostMapping(value = "/singleFileUpload", produces = MediaType.APPLICATION_JSON_UTF8_VALUE, consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    Storage[] singleFileUpload(@RequestPart(name = "file") MultipartFile file);

    /**
     * file download
     *
     * @param id
     * @return
     */
    @GetMapping("/download/{id}")
    public ResponseEntity download(@PathVariable(name = "id") String id, @RequestHeader(value = "If-Modified-Since", required = false) Date ifModified);

    /**
     * get thumbnail
     *
     * @param id
     * @param w
     * @param h
     * @return
     */
    @GetMapping("/thumbnail/{id}")
    public ResponseEntity thumbnail(@PathVariable(name = "id") String id, @RequestParam(name = "w", required = false, defaultValue = "-1") int w,
                                    @RequestParam(name = "h", required = false, defaultValue = "-1") int h,
                                    @RequestHeader(value = "If-Modified-Since", required = false) Date ifModified);


    /**
     * get thumbnail
     *
     * @param id
     * @param
     * @param
     * @return
     */
    @GetMapping("/transform/{id}")
    public ResponseEntity transform(@PathVariable(name = "id") String id);

    /**
     * file upload
     *
     * @param
     * @return
     */
    @CrossOrigin
    @RequestMapping("/findById/{id}")
    @ResponseBody
    public Storage findById(@PathVariable(name = "id") String id);

    /**
     * file upload
     *
     * @param
     * @return
     */
    @CrossOrigin
    @RequestMapping("/findByIdIn/{ids}")
    @ResponseBody
    public Set<Storage> findByIdIn(@PathVariable(name = "ids") String[] ids);

    /**
     * `
     * file upload
     *
     * @param
     * @return
     */
    @CrossOrigin
    @RequestMapping("/findByName/{name}")
    @ResponseBody
    public Set<Storage> findByName(@PathVariable(name = "name") String name);

    /**
     * file upload
     *
     * @param
     * @return
     */
    @CrossOrigin
    @RequestMapping("/find/children/{id}")
    @ResponseBody
    public List<Storage> findChildren(@PathVariable(name = "id") String id);

    @CrossOrigin
    @RequestMapping("/zip")
    @ResponseBody
    public Storage zip(@RequestParam("ids") String ids, @RequestParam(value = "name", required = false) String name);

}
