package cn.gtmap.gtcc.clients.storage;

import cn.gtmap.gtcc.domain.storage.Node;
import cn.gtmap.gtcc.domain.storage.NodeQuery;
import cn.gtmap.gtcc.domain.storage.Storage;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;
import java.util.Set;

/**
 * Created by fanyoudu on 2017/11/9.
 */
@FeignClient("storage-app")
@RequestMapping("/rest/node")
public interface NodeClient {

    /**
     * get node
     *
     * @param id
     * @return
     */
    @CrossOrigin
    @RequestMapping("/{id}")
    public Node getNodeById(@PathVariable("id") String id);

    /**
     * get nodeList
     *
     * @param owner
     * @return
     */
    @CrossOrigin
    @RequestMapping("/owner/{owner}")
    @ResponseBody
    public List<Node> getNodeListByOwner(@PathVariable("owner") String owner);

    /**
     * get nodeList
     *
     * @param query
     * @return
     */
    @CrossOrigin
    @RequestMapping("/storages/json/get")
    @ResponseBody
    public Set<Storage> getNodeListByJson(NodeQuery query);
}
