package cn.gtmap.gtcc.clients.sec;

import cn.gtmap.gtcc.domain.sec.Department;
import cn.gtmap.gtcc.domain.sec.Role;
import cn.gtmap.gtcc.domain.sec.User;
import cn.gtmap.gtcc.domain.sec.UserInfo;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * .UserClient
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/9/25 16:06
 */
@FeignClient(name = "account-app")
@RequestMapping("/account/rest/user")
public interface UserClient {

    /**
     * get user list
     *
     * @param pageable
     * @return
     */
    @GetMapping(value = "/list", consumes = MediaType.APPLICATION_JSON_UTF8_VALUE, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    Page<User> getUsers(Pageable pageable);

    @GetMapping("/queryUsers")
    public Page<User> queryUsers(Pageable pageable,
                                 @RequestParam("username") String username,
                                 @RequestParam("alias") String alias);

    /**
     * findUserByDepartmentId
     *
     * @param pageable
     * @param id
     * @return
     */
    @GetMapping("/findUserByDepartmentId")
    public Page<User> findUserByDepartmentId(Pageable pageable, @RequestParam("id") String id);
    /**
     * get user
     *
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    User getUser(@PathVariable("id") String id);

    /**
     * get user by username
     *
     * @param username
     * @return
     */
    @GetMapping("/username")
    User getUserByUsername(@RequestParam("username") String username);

    @GetMapping("/findUserByStr")
    public List<User> findUserByStr(@RequestParam("username") String username);

    /**
     * get user info
     *
     * @param id
     * @return
     */
    @GetMapping("/{id}/info")
    UserInfo getUserInfo(@PathVariable("id") String id);

    /**
     * user info update
     *
     * @param id
     * @param userInfo
     * @return
     */
    @PutMapping("/{id}/info/update")
    UserInfo updateUserInfo(@PathVariable("id") String id, @RequestBody UserInfo userInfo);

    /**
     * get user roles
     *
     * @param id
     * @return
     */
    @GetMapping("/{id}/roles")
    List getUserRoles(@PathVariable("id") String id);

    /**
     * get user roles
     *
     * @param id
     * @return
     */
    @GetMapping("/{id}/findRolesByUserId")
    List<Role> findRolesByUserId(@PathVariable("id") String id);

    /**
     * update user roles
     *
     * @param id
     * @param roleIds
     * @return
     */
    @PostMapping("/{id}/roles/update")
    boolean updateUserRoles(@PathVariable("id") String id, @RequestBody Iterable<String> roleIds);

    /**
     * update user departments
     *
     * @param id
     * @param departmentIds
     * @return
     */
    @PostMapping("/{id}/departments/update")
    boolean updateUserDepartments(@PathVariable("id") String id, @RequestBody Iterable<String> departmentIds);

    /**
     * get user departments
     *
     * @param id
     * @return
     */
    @GetMapping("/{id}/departments")
    List getUserDepartments(@PathVariable("id") String id);

    @GetMapping("/{id}/findDepartMentsByUserId")
    List<Department> findDepartMentsByUserId(@PathVariable("id") String id);

    /**
     * add user
     *
     * @param user
     * @return
     */
    @PutMapping("/add")
    User addUser(@RequestBody User user);

    /**
     * update user
     *
     * @param id
     * @param user
     * @return
     */
    @PutMapping("/{id}/update")
    User updateUser(@PathVariable("id") String id, @RequestBody User user);

    /**
     * delete user
     *
     * @param id
     * @return
     */
    @DeleteMapping("/{id}/delete")
    boolean deleteUser(@PathVariable("id") String id);

    /**
     * disable user
     *
     * @param id
     */
    @PostMapping("/{id}/disable")
    boolean disableUser(@PathVariable("id") String id);

    /**
     * 密码校验
     *
     * @param password
     * @param id
     * @return
     */
    @PostMapping("/checkUserPassword")
    public boolean checkUserPassword(@RequestParam(name = "password") String password, @RequestParam(name = "id") String id);

    @RequestMapping("/findUsersByName")
    User findUsersByName(@RequestParam("name") String name);

}
