package cn.gtmap.gtcc.clients.sec;

import cn.gtmap.gtcc.domain.sec.Operation;
import cn.gtmap.gtcc.domain.sec.Role;
import cn.gtmap.gtcc.domain.sec.User;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * .RoleClient
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/10/12 18:24
 */
@FeignClient(name = "account-app")
@RequestMapping("/account/rest/role")
public interface RoleClient {

    /**
     * get roles
     *
     * @param pageable
     * @return
     */
    @RequestMapping("/list")
    Page getRoles(Pageable pageable);

    @GetMapping("/queryRoles")
    public Page<Role> queryRoles(Pageable pageable,
                                 @RequestParam(name = "name") String name,
                                 @RequestParam(name = "alias") String alias);

    /**
     * get roles by alias
     * @param alias
     * @return
     */
    @GetMapping("/findRoleListByAlias")
    public List<Role> findRoleByAlias(@RequestParam(name = "alias") String alias);

    /**
     * get roles by ids
     * @param ids
     * @return
     */
    @GetMapping("/findRoleListByIds")
    public List<Role> findRolesByIds(@RequestParam(name = "ids") List<String> ids);
    /**
     * get roles
     *
     * @return
     */
    @RequestMapping("/roleList")
    List<Role> getRolesList();

    /**
     * get role
     *
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    Role getRole(@PathVariable("id") String id);

    /**
     * get role's users
     *
     * @param id
     * @param pageable
     * @return
     */
    @GetMapping("/{id}/users")
    Page<User> getRoleUsers(@PathVariable("id") String id, Pageable pageable);

    @GetMapping("/{id}/usersList")
    public List<User> getRoleUsers(@PathVariable("id") String id);

    /**
     * get user's operations
     *
     * @param id
     * @return
     */
    @GetMapping("/{id}/operations")
    Iterable<Operation> getRoleOperations(@PathVariable("id") String id);

    /**
     * update role
     *
     * @param id
     * @param role
     * @return
     */
    @PostMapping("/{id}/update")
    public Role updateRole(@PathVariable("id") String id, @RequestBody Role role);

    @PostMapping("/{id}/delete")
    Role deleteRole(@PathVariable("id") String id);

    @PostMapping("/{id}/deleteRoleRef")
    public void deleteRoleRef(@PathVariable("id") String id);

    @PostMapping("/{id}/deleteUserRef")
    public void deleteUserRef(@PathVariable("id") String id);

    /**
     * add role
     *
     * @param role
     * @return
     */
    @PutMapping("/add")
    Role addRole(@RequestBody Role role);

    @PostMapping("/{id}/updareRoleOperations")
    void updareRoleOperations(@PathVariable("id") String id, @RequestBody Iterable<String> operationIds);

    @GetMapping("/getUsersByRole")
    public Page<User> getUsersByRole(Pageable pageable, @RequestParam(name = "id") String id);

    @GetMapping("/deleteRefByUser")
    public boolean deleteRefByUser(@RequestParam("roleId") String roleId, @RequestParam("userId") String userId);

    @GetMapping("/queryRoleByRoleName")
    Role queryRoleByRoleName(@RequestParam("name") String name);
}
