package cn.gtmap.gtcc.clients.sec;

import cn.gtmap.gtcc.domain.sec.Operation;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * .UserClient
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/9/25 16:06
 */
@FeignClient(name = "account-app")
@RequestMapping("/account/rest/operation")
public interface OperationClient {
    /**
     * getOperations
     * @param pageable
     * @return
     */
    @GetMapping("/pageList")
    Page<Operation> getOperations(Pageable pageable);

    /**
     * getOperationList
     * @return
     */
    @GetMapping("/listAll")
    List<Operation> getOperationList();

    /**
     * getOperationbyId
     * @param id
     * @return
     */
    @GetMapping("/{id}/getOperation")
    Operation getOperation(@PathVariable("id") String id);

    /**
     * addOperation
     * @param operation
     */
    @PutMapping("/add")
    void addOperation(@RequestBody Operation operation);

    /**
     * delete
     * @param id
     * @return
     */
    @DeleteMapping("/{id}/delete")
    boolean delete(@PathVariable("id") String id);
}
