package cn.gtmap.gtcc.clients.sec;

import cn.gtmap.gtcc.domain.sec.User;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * 开放毋须权限即可访问接口
 *
 * @author shanhuashuiqing11@163.com
 * @version v1.0 2018/9/25 17:41
 */
@FeignClient(name = "account-app")
@RequestMapping("/account/noOauth")
@Component
public interface NoAuthorityClient {

    @GetMapping("/user/{id}")
    User getUser(@PathVariable("id") String id);

    @GetMapping("/{loginName}")
    User getUserByName(@PathVariable("loginName") String loginName);
}
