package cn.gtmap.gtcc.clients.sec;

import cn.gtmap.gtcc.domain.sec.Department;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

/**
 * .DepartmentClient
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/10/13 8:27
 */
@FeignClient(name = "account-app")
@RequestMapping("/account/rest/department")
public interface DepartmentClient {

    String ROOT_ID = "root";

    /**
     * get departments
     *
     * @param pageable
     * @return
     */
    @GetMapping("/list")
    Page<Department> getDepartments(Pageable pageable);

    /**
     * get root department
     *
     * @return
     */
    @GetMapping("/root")
    Iterable<Department> getRootDepartments();

    /**
     * get department
     *
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    Department getDepartment(@PathVariable(name = "id") String id);

    /**
     * get department's children
     *
     * @param id
     * @return
     */
    @GetMapping("/{id}/children")
    Iterable<Department> getChildren(@PathVariable(name = "id") String id);

    @GetMapping("/{id}/deleteDepartment")
    boolean deleteDepartment(@PathVariable(name = "id") String id);

    @GetMapping("department/{departmentId}/{userId}/deleteDepartmentUser")
    boolean deleteDepartmentUser(@PathVariable(name = "departmentId") String departmentId, @PathVariable(name = "userId") String userId);


    /**
     * add department
     *
     * @param parentId
     * @param department
     * @return
     */
    @PutMapping("/add/{parentId}")
    Department addDepartment(@PathVariable(name = "parentId") String parentId, @RequestBody Department department);

    @PostMapping("/{id}/deleteDepartmentRef")
    void deleteDepartmentRef(@PathVariable("id") String id);

    @PutMapping("/update/{parentId}")
    boolean updateDepartment(@PathVariable(name = "parentId") String parentId, @RequestBody Department department);
}
