package cn.gtmap.gtcc.clients.sec;

import cn.gtmap.gtcc.domain.resource.CommonListBean;
import cn.gtmap.gtcc.domain.sec.Authority;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * .AuthorityClient
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/9/30 11:25
 */
@FeignClient(name = "account-app")
@RequestMapping("/account/rest/authority")
public interface AuthorityClient {

    /**
     * 获取第三方自己定义的授权信息
     *
     * @param username
     * @return
     */
    @GetMapping("/{username}")
    List<Authority> getUserAuthorities(@PathVariable(name = "username") String username);

    /**
     * all authorities
     *
     * @param pageable
     * @return
     */
    @GetMapping("/list")
    Page<Authority> getUserAuthorities(Pageable pageable);

    /**
     * add authorities
     *
     * @param authorities
     * @return
     */
    @PostMapping("/add")
    boolean addAuthorities(@RequestBody List<Authority> authorities);

    @PostMapping("/delete")
    void deleteAuthorities(@RequestBody List<Authority> authorities);

    @GetMapping("/check/authority")
    boolean checkUserAuthority(@RequestBody Authority authority);

    @GetMapping("/check/authorities")
    List<Boolean> checkUserAuthorities(@RequestBody List<Authority> authorities);

    /**
     * revoke authorities
     *
     * @param authorities
     * @return
     */
    @DeleteMapping("/revoke")
    boolean revokeAuthorities(@RequestBody List<Authority> authorities);

    /**
     * find by authority like
     *
     * @param pageable
     * @return
     */
    @GetMapping("/by/authority/like")
    Page<Authority> getByAuthorityLike(@RequestParam(name = "id") String id, Pageable pageable);

    @GetMapping("/query/getAuthorityById")
    Authority getAuthorityById(@RequestParam(name = "id") String id);

    @PostMapping("/checkRoleAuthority")
    boolean checkRoleAuthority(@RequestBody CommonListBean commonListBean, @RequestParam(name = "userName") String userName,@RequestParam(name = "alias") String alias, @RequestParam(name = "authority") String authority);

    @PostMapping("/checkRoleAuthority2")
    boolean checkRoleAuthority2( @RequestParam(name = "userName") String userName, @RequestParam(name = "authority") String authority);

    /**
     * 根据authority判断是否已经授权
     *
     * @param authority
     * @return
     */
    @GetMapping("/queryByAuthority")
    Authority queryByAuthority(@RequestParam(name = "authority") String authority);
}
