package cn.gtmap.gtcc.clients.resource;

import cn.gtmap.gtcc.domain.gis.tpl.map.ResourceLayer;
import cn.gtmap.gtcc.domain.resource.dto.resource.CapableView;
import cn.gtmap.gtcc.domain.resource.dto.resource.ResourceRefView;
import cn.gtmap.gtcc.domain.resource.dto.resource.ResourceView;
import cn.gtmap.gtcc.domain.resource.dto.resource.SpatialCoverageProperty;
import cn.gtmap.gtcc.domain.resource.metadata.*;
import cn.gtmap.gtcc.domain.workflow.HistoricTaskDesc;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;

/**
 * resource client
 *
 * @author zhuzhifeng
 * @create 2018年11月15日16:37:32
 **/
@FeignClient("resource-core")
@RequestMapping("/resourceMap")
public interface ResourceMapClient {

    /**
     * 根据资源目录和行政区查询资源
     */
    @RequestMapping("/query/condition2")
    List<ResourceView> condition2(@RequestParam(name = "catalog", required = false) String catalogId,
                                  @RequestParam(name = "type", required = false) String type,
                                  @RequestParam(name = "region", required = false) String regionCode);

}
